/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class UrlRedactionUtils {
    private static String urlPattern = "(https?://)([^@/\\s]+)@(\\S*)";
    private static Pattern pattern = Pattern.compile(urlPattern, 2);

    public static String sanitizeHttpUrls(String input, String replacement) {
        if (StringUtils.isBlank((String)input)) {
            return input;
        }
        Matcher matcher = pattern.matcher(input);
        StringBuilder sanitized = new StringBuilder();
        while (matcher.find()) {
            matcher.appendReplacement(sanitized, matcher.group(1) + replacement + matcher.group(3));
        }
        matcher.appendTail(sanitized);
        return sanitized.toString();
    }

    public static String sanitizeHttpUrls(String input) {
        return UrlRedactionUtils.sanitizeHttpUrls(input, "***@");
    }

    public static String cleanHttpUrls(String input) {
        return UrlRedactionUtils.sanitizeHttpUrls(input, "");
    }
}

