/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.ConcatenateGraphFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Version;
import java.util.Map;

public class ConcatenateGraphFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "concatenateGraph";
    private Character tokenSeparator;
    private boolean preservePositionIncrements;
    private int maxGraphExpansions;

    public ConcatenateGraphFilterFactory(Map<String, String> args2) {
        super(args2);
        boolean preserveSep;
        Version luceneMatchVersion = this.getLuceneMatchVersion();
        Version LUCENE_8_4_0 = Version.LUCENE_8_4_0;
        this.tokenSeparator = luceneMatchVersion.onOrAfter(LUCENE_8_4_0) ? this.getCharacter(args2, "tokenSeparator", ConcatenateGraphFilter.DEFAULT_TOKEN_SEPARATOR) : ((preserveSep = this.getBoolean(args2, "preserveSep", true)) ? ConcatenateGraphFilter.DEFAULT_TOKEN_SEPARATOR : null);
        this.preservePositionIncrements = this.getBoolean(args2, "preservePositionIncrements", true);
        this.maxGraphExpansions = this.getInt(args2, "maxGraphExpansions", 10000);
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public ConcatenateGraphFilterFactory() {
        throw ConcatenateGraphFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new ConcatenateGraphFilter(input, this.tokenSeparator, this.preservePositionIncrements, this.maxGraphExpansions);
    }

    protected Character getCharacter(Map<String, String> args2, String name, Character defaultVal) {
        String s2 = args2.remove(name);
        if (s2 == null) {
            return defaultVal;
        }
        if (s2.length() == 0) {
            return null;
        }
        if (s2.length() != 1) {
            throw new IllegalArgumentException(name + " should be a char. \"" + s2 + "\" is invalid");
        }
        return Character.valueOf(s2.charAt(0));
    }
}

