/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.TruncateTokenFilter;
import java.util.Map;

public class TruncateTokenFilterFactory
extends TokenFilterFactory {
    public static final String NAME = "truncate";
    public static final String PREFIX_LENGTH_KEY = "prefixLength";
    private final byte prefixLength;

    public TruncateTokenFilterFactory(Map<String, String> args2) {
        super(args2);
        this.prefixLength = Byte.parseByte(this.get(args2, PREFIX_LENGTH_KEY, "5"));
        if (this.prefixLength < 1) {
            throw new IllegalArgumentException("prefixLength parameter must be a positive number: " + this.prefixLength);
        }
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameter(s): " + args2);
        }
    }

    public TruncateTokenFilterFactory() {
        throw TruncateTokenFilterFactory.defaultCtorException();
    }

    @Override
    public TokenStream create(TokenStream input) {
        return new TruncateTokenFilter(input, this.prefixLength);
    }
}

