/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.search;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DoubleValues;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DoubleValuesSource;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.VectorScorer;
import java.io.IOException;

abstract class VectorSimilarityValuesSource
extends DoubleValuesSource {
    protected final String fieldName;

    public VectorSimilarityValuesSource(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public DoubleValues getValues(LeafReaderContext ctx, DoubleValues scores) throws IOException {
        final VectorScorer scorer = this.getScorer(ctx);
        if (scorer == null) {
            return DoubleValues.EMPTY;
        }
        final DocIdSetIterator iterator2 = scorer.iterator();
        return new DoubleValues(){

            @Override
            public double doubleValue() throws IOException {
                return scorer.score();
            }

            @Override
            public boolean advanceExact(int doc) throws IOException {
                return doc >= iterator2.docID() && (iterator2.docID() == doc || iterator2.advance(doc) == doc);
            }
        };
    }

    protected abstract VectorScorer getScorer(LeafReaderContext var1) throws IOException;

    @Override
    public boolean needsScores() {
        return false;
    }

    @Override
    public DoubleValuesSource rewrite(IndexSearcher reader) throws IOException {
        return this;
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }
}

