/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.util.bkd;

import com.dataiku.dss.shadelib.org.apache.lucene.util.ArrayUtil;

public final class BKDConfig {
    public static final int DEFAULT_MAX_POINTS_IN_LEAF_NODE = 512;
    public static final int MAX_DIMS = 16;
    public static final int MAX_INDEX_DIMS = 8;
    public final int numDims;
    public final int numIndexDims;
    public final int bytesPerDim;
    public final int maxPointsInLeafNode;
    public final int packedBytesLength;
    public final int packedIndexBytesLength;
    public final int bytesPerDoc;

    public BKDConfig(int numDims, int numIndexDims, int bytesPerDim, int maxPointsInLeafNode) {
        BKDConfig.verifyParams(numDims, numIndexDims, bytesPerDim, maxPointsInLeafNode);
        this.numDims = numDims;
        this.numIndexDims = numIndexDims;
        this.bytesPerDim = bytesPerDim;
        this.maxPointsInLeafNode = maxPointsInLeafNode;
        this.packedIndexBytesLength = numIndexDims * bytesPerDim;
        this.packedBytesLength = numDims * bytesPerDim;
        this.bytesPerDoc = this.packedBytesLength + 4;
    }

    private static void verifyParams(int numDims, int numIndexDims, int bytesPerDim, int maxPointsInLeafNode) {
        if (numDims < 1 || numDims > 16) {
            throw new IllegalArgumentException("numDims must be 1 .. 16 (got: " + numDims + ")");
        }
        if (numIndexDims < 1 || numIndexDims > 8) {
            throw new IllegalArgumentException("numIndexDims must be 1 .. 8 (got: " + numIndexDims + ")");
        }
        if (numIndexDims > numDims) {
            throw new IllegalArgumentException("numIndexDims cannot exceed numDims (" + numDims + ") (got: " + numIndexDims + ")");
        }
        if (bytesPerDim <= 0) {
            throw new IllegalArgumentException("bytesPerDim must be > 0; got " + bytesPerDim);
        }
        if (maxPointsInLeafNode <= 0) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be > 0; got " + maxPointsInLeafNode);
        }
        if (maxPointsInLeafNode > ArrayUtil.MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("maxPointsInLeafNode must be <= ArrayUtil.MAX_ARRAY_LENGTH (= " + ArrayUtil.MAX_ARRAY_LENGTH + "); got " + maxPointsInLeafNode);
        }
    }
}

