/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.server;

import com.dataiku.dss.shadelib.org.eclipse.jetty.io.ClientConnector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.Connection;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.EndPoint;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.Transport;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.MemoryConnector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Promise;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Objects;

public class MemoryTransport
implements Transport {
    private final MemoryConnector connector;

    public MemoryTransport(MemoryConnector connector) {
        this.connector = connector;
    }

    @Override
    public void connect(SocketAddress socketAddress, Map<String, Object> context) {
        Promise promise = (Promise)context.get("com.dataiku.dss.shadelib.org.eclipse.jetty.client.connector.connectionPromise");
        try {
            EndPoint endPoint = this.connector.connect().getLocalEndPoint();
            ClientConnector clientConnector = (ClientConnector)context.get("com.dataiku.dss.shadelib.org.eclipse.jetty.client.connector");
            endPoint.setIdleTimeout(clientConnector.getIdleTimeout().toMillis());
            Transport transport = (Transport)context.get(Transport.class.getName());
            Connection connection = transport.newConnection(endPoint, context);
            endPoint.setConnection(connection);
            endPoint.onOpen();
            connection.onOpen();
            promise.succeeded(connection);
        }
        catch (Throwable x) {
            promise.failed(x);
        }
    }

    @Override
    public SocketAddress getSocketAddress() {
        return this.connector.getLocalSocketAddress();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.connector);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof MemoryTransport) {
            MemoryTransport that = (MemoryTransport)obj;
            return Objects.equals(this.connector, that.connector);
        }
        return false;
    }
}

