/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.util;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.IO;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Promise;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.Invocable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blocker {
    private static final Logger LOG = LoggerFactory.getLogger(Blocker.class);
    private static final Throwable ACQUIRED = new Throwable(){

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    };
    private static final Throwable SUCCEEDED = new Throwable(){

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    };

    public static Runnable runnable() {
        return new Runnable(){
            final CountDownLatch _complete = new CountDownLatch(1);

            @Override
            public void run() {
                this._complete.countDown();
            }

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public void block() throws IOException {
                try {
                    this._complete.await();
                }
                catch (Throwable t2) {
                    throw IO.rethrow(t2);
                }
            }

            @Override
            public void close() {
                if (this._complete.getCount() != 0L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Blocking.Runnable incomplete", new Throwable());
                    } else {
                        LOG.warn("Blocking.Runnable incomplete");
                    }
                }
            }
        };
    }

    public static Callback callback() {
        return new Callback(){
            private final CompletableFuture<Throwable> _future = new CompletableFuture();

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public void succeeded() {
                this._future.complete(SUCCEEDED);
            }

            @Override
            public void failed(Throwable x) {
                this._future.complete(x == null ? new Throwable() : x);
            }

            @Override
            public void block() throws IOException {
                Throwable result;
                try {
                    result = this._future.get();
                }
                catch (Throwable t2) {
                    result = t2;
                }
                if (result == SUCCEEDED) {
                    return;
                }
                throw IO.rethrow(result);
            }

            @Override
            public void close() {
                if (!this._future.isDone()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Blocking.Callback incomplete", new Throwable());
                    } else {
                        LOG.warn("Blocking.Callback incomplete");
                    }
                }
            }
        };
    }

    public static <C> Promise<C> promise() {
        return new Promise<C>(){
            private final CompletableFuture<C> _future = new CompletableFuture();

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public C block() throws IOException {
                try {
                    return this._future.get();
                }
                catch (Throwable t2) {
                    throw IO.rethrow(t2);
                }
            }

            @Override
            public void close() {
                if (!this._future.isDone()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Blocking.Promise incomplete", new Throwable());
                    } else {
                        LOG.warn("Blocking.Promise incomplete");
                    }
                }
            }

            @Override
            public void succeeded(C result) {
                this._future.complete(result);
            }

            @Override
            public void failed(Throwable x) {
                this._future.completeExceptionally(x);
            }
        };
    }

    public static class Shared {
        private final ReentrantLock _lock = new ReentrantLock();
        private final Condition _idle = this._lock.newCondition();
        private final Condition _complete = this._lock.newCondition();
        private Throwable _completed;
        private final Callback _callback = new Callback(){

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public void succeeded() {
                _lock.lock();
                try {
                    if (_completed == ACQUIRED) {
                        _completed = SUCCEEDED;
                        _complete.signalAll();
                    }
                }
                finally {
                    _lock.unlock();
                }
            }

            @Override
            public void failed(Throwable x) {
                _lock.lock();
                try {
                    if (_completed == ACQUIRED) {
                        _completed = x;
                        _complete.signalAll();
                    }
                }
                finally {
                    _lock.unlock();
                }
            }

            @Override
            public void block() throws IOException {
                Throwable result;
                _lock.lock();
                try {
                    while (_completed == ACQUIRED) {
                        _complete.await();
                    }
                    result = _completed;
                }
                catch (Throwable t2) {
                    result = t2;
                }
                finally {
                    _lock.unlock();
                }
                if (result != SUCCEEDED) {
                    throw IO.rethrow(result);
                }
            }

            @Override
            public void close() {
                boolean completed;
                _lock.lock();
                try {
                    completed = _completed != ACQUIRED;
                }
                finally {
                    _completed = null;
                    _idle.signalAll();
                    _lock.unlock();
                }
                if (!completed) {
                    if (LOG.isDebugEnabled()) {
                        LOG.warn("Blocking.Shared incomplete", new Throwable());
                    } else {
                        LOG.warn("Blocking.Shared incomplete");
                    }
                }
            }
        };
        private final Runnable _runnable = new Runnable(){

            @Override
            public Invocable.InvocationType getInvocationType() {
                return Invocable.InvocationType.NON_BLOCKING;
            }

            @Override
            public void run() {
                _callback.succeeded();
            }

            @Override
            public void block() throws IOException {
                _callback.block();
            }

            @Override
            public void close() {
                _callback.close();
            }
        };

        public Callback callback() throws IOException {
            this._lock.lock();
            try {
                while (this._completed != null) {
                    this._idle.await();
                }
                this._completed = ACQUIRED;
                Callback callback = this._callback;
                return callback;
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
            finally {
                this._lock.unlock();
            }
        }

        public Runnable runnable() throws IOException {
            this._lock.lock();
            try {
                while (this._completed != null) {
                    this._idle.await();
                }
                this._completed = ACQUIRED;
                Runnable runnable = this._runnable;
                return runnable;
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
            finally {
                this._lock.unlock();
            }
        }
    }

    public static interface Promise<C>
    extends Promise.Invocable<C>,
    AutoCloseable {
        public C block() throws IOException;

        @Override
        public void close();
    }

    public static interface Callback
    extends com.dataiku.dss.shadelib.org.eclipse.jetty.util.Callback,
    AutoCloseable,
    Invocable {
        public void block() throws IOException;

        @Override
        public void close();
    }

    public static interface Runnable
    extends java.lang.Runnable,
    AutoCloseable,
    Invocable {
        public void block() throws IOException;

        @Override
        public void close();
    }
}

