/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie;

import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.Contract;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.CommonCookieAttributeHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.Cookie;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.CookieOrigin;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.CookieRestrictionViolationException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.MalformedCookieException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.SetCookie;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie.AbstractCookieAttributeHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            cookie.setVersion(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new MalformedCookieException("Invalid version: " + e.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

