/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.impl.cookie;

import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.Contract;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.annotation.ThreadingBehavior;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.ClientCookie;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.CommonCookieAttributeHandler;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.Cookie;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.CookieOrigin;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.CookieRestrictionViolationException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.MalformedCookieException;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.SetCookie;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.cookie.SetCookie2;
import com.dataiku.dss.shadelib.org.mlflow_project.apachehttp.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RFC2965VersionAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        int version = -1;
        try {
            version = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            version = -1;
        }
        if (version < 0) {
            throw new MalformedCookieException("Invalid cookie version.");
        }
        cookie.setVersion(version);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie instanceof SetCookie2 && cookie instanceof ClientCookie && !((ClientCookie)cookie).containsAttribute("version")) {
            throw new CookieRestrictionViolationException("Violates RFC 2965. Version attribute is required.");
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        return true;
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

