/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateSnapshotsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.InstanceSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateSnapshotsRequestMarshaller
implements Marshaller<Request<CreateSnapshotsRequest>, CreateSnapshotsRequest> {
    @Override
    public Request<CreateSnapshotsRequest> marshall(CreateSnapshotsRequest createSnapshotsRequest) {
        SdkInternalList createSnapshotsRequestTagSpecificationsList;
        InstanceSpecification instanceSpecification;
        if (createSnapshotsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateSnapshotsRequest> request = new DefaultRequest<CreateSnapshotsRequest>(createSnapshotsRequest, "AmazonEC2");
        request.addParameter("Action", "CreateSnapshots");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createSnapshotsRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createSnapshotsRequest.getDescription()));
        }
        if ((instanceSpecification = createSnapshotsRequest.getInstanceSpecification()) != null) {
            SdkInternalList instanceSpecificationExcludeDataVolumeIdsList;
            if (instanceSpecification.getInstanceId() != null) {
                request.addParameter("InstanceSpecification.InstanceId", StringUtils.fromString(instanceSpecification.getInstanceId()));
            }
            if (instanceSpecification.getExcludeBootVolume() != null) {
                request.addParameter("InstanceSpecification.ExcludeBootVolume", StringUtils.fromBoolean(instanceSpecification.getExcludeBootVolume()));
            }
            if (!(instanceSpecificationExcludeDataVolumeIdsList = (SdkInternalList)instanceSpecification.getExcludeDataVolumeIds()).isEmpty() || !instanceSpecificationExcludeDataVolumeIdsList.isAutoConstruct()) {
                int excludeDataVolumeIdsListIndex = 1;
                for (String instanceSpecificationExcludeDataVolumeIdsListValue : instanceSpecificationExcludeDataVolumeIdsList) {
                    if (instanceSpecificationExcludeDataVolumeIdsListValue != null) {
                        request.addParameter("InstanceSpecification.ExcludeDataVolumeId." + excludeDataVolumeIdsListIndex, StringUtils.fromString(instanceSpecificationExcludeDataVolumeIdsListValue));
                    }
                    ++excludeDataVolumeIdsListIndex;
                }
            }
        }
        if (createSnapshotsRequest.getOutpostArn() != null) {
            request.addParameter("OutpostArn", StringUtils.fromString(createSnapshotsRequest.getOutpostArn()));
        }
        if (!(createSnapshotsRequestTagSpecificationsList = (SdkInternalList)createSnapshotsRequest.getTagSpecifications()).isEmpty() || !createSnapshotsRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createSnapshotsRequestTagSpecificationsListValue : createSnapshotsRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createSnapshotsRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createSnapshotsRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createSnapshotsRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createSnapshotsRequest.getCopyTagsFromSource() != null) {
            request.addParameter("CopyTagsFromSource", StringUtils.fromString(createSnapshotsRequest.getCopyTagsFromSource()));
        }
        return request;
    }
}

