/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateSubnetRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.Tag;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TagSpecification;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateSubnetRequestMarshaller
implements Marshaller<Request<CreateSubnetRequest>, CreateSubnetRequest> {
    @Override
    public Request<CreateSubnetRequest> marshall(CreateSubnetRequest createSubnetRequest) {
        if (createSubnetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateSubnetRequest> request = new DefaultRequest<CreateSubnetRequest>(createSubnetRequest, "AmazonEC2");
        request.addParameter("Action", "CreateSubnet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList createSubnetRequestTagSpecificationsList = (SdkInternalList)createSubnetRequest.getTagSpecifications();
        if (!createSubnetRequestTagSpecificationsList.isEmpty() || !createSubnetRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createSubnetRequestTagSpecificationsListValue : createSubnetRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createSubnetRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString(createSubnetRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createSubnetRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createSubnetRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString(createSubnetRequest.getAvailabilityZone()));
        }
        if (createSubnetRequest.getAvailabilityZoneId() != null) {
            request.addParameter("AvailabilityZoneId", StringUtils.fromString(createSubnetRequest.getAvailabilityZoneId()));
        }
        if (createSubnetRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString(createSubnetRequest.getCidrBlock()));
        }
        if (createSubnetRequest.getIpv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringUtils.fromString(createSubnetRequest.getIpv6CidrBlock()));
        }
        if (createSubnetRequest.getOutpostArn() != null) {
            request.addParameter("OutpostArn", StringUtils.fromString(createSubnetRequest.getOutpostArn()));
        }
        if (createSubnetRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(createSubnetRequest.getVpcId()));
        }
        if (createSubnetRequest.getIpv6Native() != null) {
            request.addParameter("Ipv6Native", StringUtils.fromBoolean(createSubnetRequest.getIpv6Native()));
        }
        if (createSubnetRequest.getIpv4IpamPoolId() != null) {
            request.addParameter("Ipv4IpamPoolId", StringUtils.fromString(createSubnetRequest.getIpv4IpamPoolId()));
        }
        if (createSubnetRequest.getIpv4NetmaskLength() != null) {
            request.addParameter("Ipv4NetmaskLength", StringUtils.fromInteger(createSubnetRequest.getIpv4NetmaskLength()));
        }
        if (createSubnetRequest.getIpv6IpamPoolId() != null) {
            request.addParameter("Ipv6IpamPoolId", StringUtils.fromString(createSubnetRequest.getIpv6IpamPoolId()));
        }
        if (createSubnetRequest.getIpv6NetmaskLength() != null) {
            request.addParameter("Ipv6NetmaskLength", StringUtils.fromInteger(createSubnetRequest.getIpv6NetmaskLength()));
        }
        return request;
    }
}

