/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.StructuredPojo;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.DeltaTargetCompressionType;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.DirectSchemaChangePolicy;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.TargetFormat;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.transform.S3DeltaDirectTargetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class S3DeltaDirectTarget
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private List<String> inputs;
    private List<List<String>> partitionKeys;
    private String path;
    private String compression;
    private String format;
    private Map<String, String> additionalOptions;
    private DirectSchemaChangePolicy schemaChangePolicy;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public S3DeltaDirectTarget withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getInputs() {
        return this.inputs;
    }

    public void setInputs(Collection<String> inputs) {
        if (inputs == null) {
            this.inputs = null;
            return;
        }
        this.inputs = new ArrayList<String>(inputs);
    }

    public S3DeltaDirectTarget withInputs(String ... inputs) {
        if (this.inputs == null) {
            this.setInputs(new ArrayList<String>(inputs.length));
        }
        for (String ele : inputs) {
            this.inputs.add(ele);
        }
        return this;
    }

    public S3DeltaDirectTarget withInputs(Collection<String> inputs) {
        this.setInputs(inputs);
        return this;
    }

    public List<List<String>> getPartitionKeys() {
        return this.partitionKeys;
    }

    public void setPartitionKeys(Collection<List<String>> partitionKeys) {
        if (partitionKeys == null) {
            this.partitionKeys = null;
            return;
        }
        this.partitionKeys = new ArrayList<List<String>>(partitionKeys);
    }

    public S3DeltaDirectTarget withPartitionKeys(List<String> ... partitionKeys) {
        if (this.partitionKeys == null) {
            this.setPartitionKeys(new ArrayList<List<String>>(partitionKeys.length));
        }
        for (List<String> ele : partitionKeys) {
            this.partitionKeys.add(ele);
        }
        return this;
    }

    public S3DeltaDirectTarget withPartitionKeys(Collection<List<String>> partitionKeys) {
        this.setPartitionKeys(partitionKeys);
        return this;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public S3DeltaDirectTarget withPath(String path) {
        this.setPath(path);
        return this;
    }

    public void setCompression(String compression) {
        this.compression = compression;
    }

    public String getCompression() {
        return this.compression;
    }

    public S3DeltaDirectTarget withCompression(String compression) {
        this.setCompression(compression);
        return this;
    }

    public S3DeltaDirectTarget withCompression(DeltaTargetCompressionType compression) {
        this.compression = compression.toString();
        return this;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public S3DeltaDirectTarget withFormat(String format) {
        this.setFormat(format);
        return this;
    }

    public S3DeltaDirectTarget withFormat(TargetFormat format) {
        this.format = format.toString();
        return this;
    }

    public Map<String, String> getAdditionalOptions() {
        return this.additionalOptions;
    }

    public void setAdditionalOptions(Map<String, String> additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    public S3DeltaDirectTarget withAdditionalOptions(Map<String, String> additionalOptions) {
        this.setAdditionalOptions(additionalOptions);
        return this;
    }

    public S3DeltaDirectTarget addAdditionalOptionsEntry(String key, String value) {
        if (null == this.additionalOptions) {
            this.additionalOptions = new HashMap<String, String>();
        }
        if (this.additionalOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.additionalOptions.put(key, value);
        return this;
    }

    public S3DeltaDirectTarget clearAdditionalOptionsEntries() {
        this.additionalOptions = null;
        return this;
    }

    public void setSchemaChangePolicy(DirectSchemaChangePolicy schemaChangePolicy) {
        this.schemaChangePolicy = schemaChangePolicy;
    }

    public DirectSchemaChangePolicy getSchemaChangePolicy() {
        return this.schemaChangePolicy;
    }

    public S3DeltaDirectTarget withSchemaChangePolicy(DirectSchemaChangePolicy schemaChangePolicy) {
        this.setSchemaChangePolicy(schemaChangePolicy);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getInputs() != null) {
            sb.append("Inputs: ").append(this.getInputs()).append(",");
        }
        if (this.getPartitionKeys() != null) {
            sb.append("PartitionKeys: ").append(this.getPartitionKeys()).append(",");
        }
        if (this.getPath() != null) {
            sb.append("Path: ").append(this.getPath()).append(",");
        }
        if (this.getCompression() != null) {
            sb.append("Compression: ").append(this.getCompression()).append(",");
        }
        if (this.getFormat() != null) {
            sb.append("Format: ").append(this.getFormat()).append(",");
        }
        if (this.getAdditionalOptions() != null) {
            sb.append("AdditionalOptions: ").append(this.getAdditionalOptions()).append(",");
        }
        if (this.getSchemaChangePolicy() != null) {
            sb.append("SchemaChangePolicy: ").append(this.getSchemaChangePolicy());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3DeltaDirectTarget)) {
            return false;
        }
        S3DeltaDirectTarget other = (S3DeltaDirectTarget)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getInputs() == null ^ this.getInputs() == null) {
            return false;
        }
        if (other.getInputs() != null && !other.getInputs().equals(this.getInputs())) {
            return false;
        }
        if (other.getPartitionKeys() == null ^ this.getPartitionKeys() == null) {
            return false;
        }
        if (other.getPartitionKeys() != null && !other.getPartitionKeys().equals(this.getPartitionKeys())) {
            return false;
        }
        if (other.getPath() == null ^ this.getPath() == null) {
            return false;
        }
        if (other.getPath() != null && !other.getPath().equals(this.getPath())) {
            return false;
        }
        if (other.getCompression() == null ^ this.getCompression() == null) {
            return false;
        }
        if (other.getCompression() != null && !other.getCompression().equals(this.getCompression())) {
            return false;
        }
        if (other.getFormat() == null ^ this.getFormat() == null) {
            return false;
        }
        if (other.getFormat() != null && !other.getFormat().equals(this.getFormat())) {
            return false;
        }
        if (other.getAdditionalOptions() == null ^ this.getAdditionalOptions() == null) {
            return false;
        }
        if (other.getAdditionalOptions() != null && !other.getAdditionalOptions().equals(this.getAdditionalOptions())) {
            return false;
        }
        if (other.getSchemaChangePolicy() == null ^ this.getSchemaChangePolicy() == null) {
            return false;
        }
        return other.getSchemaChangePolicy() == null || other.getSchemaChangePolicy().equals(this.getSchemaChangePolicy());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getInputs() == null ? 0 : this.getInputs().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionKeys() == null ? 0 : this.getPartitionKeys().hashCode());
        hashCode = 31 * hashCode + (this.getPath() == null ? 0 : this.getPath().hashCode());
        hashCode = 31 * hashCode + (this.getCompression() == null ? 0 : this.getCompression().hashCode());
        hashCode = 31 * hashCode + (this.getFormat() == null ? 0 : this.getFormat().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalOptions() == null ? 0 : this.getAdditionalOptions().hashCode());
        hashCode = 31 * hashCode + (this.getSchemaChangePolicy() == null ? 0 : this.getSchemaChangePolicy().hashCode());
        return hashCode;
    }

    public S3DeltaDirectTarget clone() {
        try {
            return (S3DeltaDirectTarget)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3DeltaDirectTargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

