/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallLocation;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingType;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.glue.model.DecimalNumber;
import java.nio.ByteBuffer;

@SdkInternalApi
public class DecimalNumberMarshaller {
    private static final MarshallingInfo<ByteBuffer> UNSCALEDVALUE_BINDING = MarshallingInfo.builder(MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UnscaledValue").build();
    private static final MarshallingInfo<Integer> SCALE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Scale").build();
    private static final DecimalNumberMarshaller instance = new DecimalNumberMarshaller();

    public static DecimalNumberMarshaller getInstance() {
        return instance;
    }

    public void marshall(DecimalNumber decimalNumber, ProtocolMarshaller protocolMarshaller) {
        if (decimalNumber == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(decimalNumber.getUnscaledValue(), UNSCALEDVALUE_BINDING);
            protocolMarshaller.marshall(decimalNumber.getScale(), SCALE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

