/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.services.route53.model.Coordinates;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.StaxUnmarshallerContext;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CoordinatesStaxUnmarshaller
implements Unmarshaller<Coordinates, StaxUnmarshallerContext> {
    private static CoordinatesStaxUnmarshaller instance;

    @Override
    public Coordinates unmarshall(StaxUnmarshallerContext context) throws Exception {
        Coordinates coordinates = new Coordinates();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return coordinates;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Latitude", targetDepth)) {
                    coordinates.setLatitude(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Longitude", targetDepth)) continue;
                coordinates.setLongitude(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return coordinates;
    }

    public static CoordinatesStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CoordinatesStaxUnmarshaller();
        }
        return instance;
    }
}

