/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallLocation;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingInfo;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.MarshallingType;
import com.dataiku.dss.legacy.aws.com.amazonaws.protocol.ProtocolMarshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.EdgeModel;
import java.util.Date;

@SdkInternalApi
public class EdgeModelMarshaller {
    private static final MarshallingInfo<String> MODELNAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelName").build();
    private static final MarshallingInfo<String> MODELVERSION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ModelVersion").build();
    private static final MarshallingInfo<Date> LATESTSAMPLETIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestSampleTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> LATESTINFERENCE_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LatestInference").timestampFormat("unixTimestamp").build();
    private static final EdgeModelMarshaller instance = new EdgeModelMarshaller();

    public static EdgeModelMarshaller getInstance() {
        return instance;
    }

    public void marshall(EdgeModel edgeModel, ProtocolMarshaller protocolMarshaller) {
        if (edgeModel == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(edgeModel.getModelName(), MODELNAME_BINDING);
            protocolMarshaller.marshall(edgeModel.getModelVersion(), MODELVERSION_BINDING);
            protocolMarshaller.marshall(edgeModel.getLatestSampleTime(), LATESTSAMPLETIME_BINDING);
            protocolMarshaller.marshall(edgeModel.getLatestInference(), LATESTINFERENCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

