/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.AmazonSageMaker;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeEndpointRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeEndpointResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeImageRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeImageResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeImageVersionRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeImageVersionResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeNotebookInstanceRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeNotebookInstanceResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeProcessingJobRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeProcessingJobResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeTrainingJobRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeTrainingJobResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeTransformJobRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.model.DescribeTransformJobResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.DescribeEndpointFunction;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.DescribeImageFunction;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.DescribeImageVersionFunction;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.DescribeNotebookInstanceFunction;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.DescribeProcessingJobFunction;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.DescribeTrainingJobFunction;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.DescribeTransformJobFunction;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.EndpointDeleted;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.EndpointInService;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.ImageCreated;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.ImageDeleted;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.ImageUpdated;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.ImageVersionCreated;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.ImageVersionDeleted;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.NotebookInstanceDeleted;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.NotebookInstanceInService;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.NotebookInstanceStopped;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.ProcessingJobCompletedOrStopped;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.TrainingJobCompletedOrStopped;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.sagemaker.waiters.TransformJobCompletedOrStopped;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.FixedDelayStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.PollingStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.Waiter;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterBuilder;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonSageMakerWaiters {
    private final AmazonSageMaker client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonSageMakerWaiters");

    @SdkInternalApi
    public AmazonSageMakerWaiters(AmazonSageMaker client) {
        this.client = client;
    }

    public Waiter<DescribeImageRequest> imageDeleted() {
        return new WaiterBuilder<DescribeImageRequest, DescribeImageResult>().withSdkFunction(new DescribeImageFunction(this.client)).withAcceptors(new ImageDeleted.IsResourceNotFoundExceptionMatcher(), new ImageDeleted.IsDELETE_FAILEDMatcher(), new ImageDeleted.IsValidationExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstanceStopped() {
        return new WaiterBuilder<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResult>().withSdkFunction(new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new NotebookInstanceStopped.IsStoppedMatcher(), new NotebookInstanceStopped.IsFailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstanceInService() {
        return new WaiterBuilder<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResult>().withSdkFunction(new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new NotebookInstanceInService.IsInServiceMatcher(), new NotebookInstanceInService.IsFailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTransformJobRequest> transformJobCompletedOrStopped() {
        return new WaiterBuilder<DescribeTransformJobRequest, DescribeTransformJobResult>().withSdkFunction(new DescribeTransformJobFunction(this.client)).withAcceptors(new TransformJobCompletedOrStopped.IsCompletedMatcher(), new TransformJobCompletedOrStopped.IsStoppedMatcher(), new TransformJobCompletedOrStopped.IsFailedMatcher(), new TransformJobCompletedOrStopped.IsValidationExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeTrainingJobRequest> trainingJobCompletedOrStopped() {
        return new WaiterBuilder<DescribeTrainingJobRequest, DescribeTrainingJobResult>().withSdkFunction(new DescribeTrainingJobFunction(this.client)).withAcceptors(new TrainingJobCompletedOrStopped.IsCompletedMatcher(), new TrainingJobCompletedOrStopped.IsStoppedMatcher(), new TrainingJobCompletedOrStopped.IsFailedMatcher(), new TrainingJobCompletedOrStopped.IsValidationExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(180), new FixedDelayStrategy(120))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeImageRequest> imageCreated() {
        return new WaiterBuilder<DescribeImageRequest, DescribeImageResult>().withSdkFunction(new DescribeImageFunction(this.client)).withAcceptors(new ImageCreated.IsCREATEDMatcher(), new ImageCreated.IsCREATE_FAILEDMatcher(), new ImageCreated.IsValidationExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeImageVersionRequest> imageVersionDeleted() {
        return new WaiterBuilder<DescribeImageVersionRequest, DescribeImageVersionResult>().withSdkFunction(new DescribeImageVersionFunction(this.client)).withAcceptors(new ImageVersionDeleted.IsResourceNotFoundExceptionMatcher(), new ImageVersionDeleted.IsDELETE_FAILEDMatcher(), new ImageVersionDeleted.IsValidationExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeNotebookInstanceRequest> notebookInstanceDeleted() {
        return new WaiterBuilder<DescribeNotebookInstanceRequest, DescribeNotebookInstanceResult>().withSdkFunction(new DescribeNotebookInstanceFunction(this.client)).withAcceptors(new NotebookInstanceDeleted.IsValidationExceptionMatcher(), new NotebookInstanceDeleted.IsFailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEndpointRequest> endpointInService() {
        return new WaiterBuilder<DescribeEndpointRequest, DescribeEndpointResult>().withSdkFunction(new DescribeEndpointFunction(this.client)).withAcceptors(new EndpointInService.IsInServiceMatcher(), new EndpointInService.IsFailedMatcher(), new EndpointInService.IsValidationExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(120), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEndpointRequest> endpointDeleted() {
        return new WaiterBuilder<DescribeEndpointRequest, DescribeEndpointResult>().withSdkFunction(new DescribeEndpointFunction(this.client)).withAcceptors(new EndpointDeleted.IsValidationExceptionMatcher(), new EndpointDeleted.IsFailedMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeProcessingJobRequest> processingJobCompletedOrStopped() {
        return new WaiterBuilder<DescribeProcessingJobRequest, DescribeProcessingJobResult>().withSdkFunction(new DescribeProcessingJobFunction(this.client)).withAcceptors(new ProcessingJobCompletedOrStopped.IsCompletedMatcher(), new ProcessingJobCompletedOrStopped.IsStoppedMatcher(), new ProcessingJobCompletedOrStopped.IsFailedMatcher(), new ProcessingJobCompletedOrStopped.IsValidationExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeImageRequest> imageUpdated() {
        return new WaiterBuilder<DescribeImageRequest, DescribeImageResult>().withSdkFunction(new DescribeImageFunction(this.client)).withAcceptors(new ImageUpdated.IsCREATEDMatcher(), new ImageUpdated.IsUPDATE_FAILEDMatcher(), new ImageUpdated.IsValidationExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeImageVersionRequest> imageVersionCreated() {
        return new WaiterBuilder<DescribeImageVersionRequest, DescribeImageVersionResult>().withSdkFunction(new DescribeImageVersionFunction(this.client)).withAcceptors(new ImageVersionCreated.IsCREATEDMatcher(), new ImageVersionCreated.IsCREATE_FAILEDMatcher(), new ImageVersionCreated.IsValidationExceptionMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(60))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

