(function() {
    'use strict';

    const afgRelationshipIcons = {
        templateUrl: 'static/dataiku/auto-feature-generation/afg-relationships-icons/afg-relationship-icons.component.html',
        bindings: {
            relationshipType: '<',
            leftTableIndex: '<',
            rightTableIndex: '<',
        },
        controller: function(AutoFeatureGenerationRecipeService) {
            const $ctrl = this;

            $ctrl.$onChanges = () => {
                $ctrl.leftIcon = AutoFeatureGenerationRecipeService.getLeftSymbolFromRelationship($ctrl.relationshipType);
                $ctrl.rightIcon = AutoFeatureGenerationRecipeService.getRightSymbolFromRelationship($ctrl.relationshipType);
                $ctrl.leftColor = AutoFeatureGenerationRecipeService.getDatasetColorClass($ctrl.leftTableIndex);
                $ctrl.rightColor = AutoFeatureGenerationRecipeService.getDatasetColorClass($ctrl.rightTableIndex);
            }
        },
    }

    angular.module('dataiku.autoFeatureGeneration')
        .component('afgRelationshipIcons', afgRelationshipIcons);
})();
