(function(){
    'use strict';

    const projectSummaryList = {
        bindings : {
            summary: "<",
        },
        templateUrl : "static/dataiku/shared/components/project-summary-list-component/project-summary-list.component.html",
        controller: function (){
            const $ctrl = this;
            $ctrl.notebookCount = 0;

            $ctrl.$onChanges = (changes) => {
                if (changes && changes.summary && changes.summary.currentValue) {
                    $ctrl.notebookCount = $ctrl.summary.jupyterNotebooks + $ctrl.summary.sqlNotebooks + $ctrl.summary.searchNotebooks;
                }
            };
        }
    }

    angular.module('dataiku.shared').component('projectSummaryList', projectSummaryList);
})();