from dataiku.doctor.utils import unix_time_millis


class ModelTrainingInfoHandler(object):
    """
    Handles the update of model information file on disk, to inform the front-end on the progress of the training
    """
    INFO_FILENAME = None

    def __init__(self, folder_context, delay=2):
        """
        :type folder_context: dataiku.base.folder_context.FolderContext
        :param delay: In seconds, minimum time to wait to write the info, if not `force`
        """
        self.folder_context = folder_context
        self.delay = delay
        self._last_updated = unix_time_millis()

    def _should_update(self):
        curr_time = unix_time_millis()
        if (curr_time - self._last_updated) > self.delay * 1000:
            self._last_updated = curr_time
            return True
        return False

    def to_dict(self):
        raise NotImplementedError()

    def update_info(self, force=False):
        if force or self._should_update():
            self.folder_context.write_json("{}.json".format(self.INFO_FILENAME), self.to_dict())
