from dataiku.eda.types import Literal

import numpy as np

from dataiku.eda.computations.computation import UnivariateComputation
from dataiku.eda.computations.context import Context
from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.exceptions import NoDataError
from dataiku.eda.types import StdDevModel, StdDevResultModel


class StdDev(UnivariateComputation):
    @staticmethod
    def get_type() -> Literal["std_dev"]:
        return "std_dev"

    @staticmethod
    def build(params: StdDevModel) -> 'StdDev':
        return StdDev(params['column'])

    def apply(self, idf: ImmutableDataFrame, ctx: Context) -> StdDevResultModel:
        series = idf.float_col_no_missing(self.column)

        if len(series) == 0:
            raise NoDataError()
        elif len(series) == 1:
            std = 0.0
        else:
            std = np.std(series, ddof=1)

        return {"type": self.get_type(), "value": std}
