import logging

from dataiku.external_ml.proxy_model.sagemaker.inputformat.abstract_sagemaker_writer import AbstractSagemakerWriter

logger = logging.getLogger(__name__)


class SagemakerCSVWriter(AbstractSagemakerWriter):
    NAME = "INPUT_SAGEMAKER_CSV"

    def __init__(self, client):
        super(SagemakerCSVWriter, self).__init__(client)

    def build_request_payload(self, input_df):
        return input_df.to_csv(index=False, header=False)

    def write(self, input_df):
        # Note: content_type is *not* an HTTP header in this case
        return self.client.call_endpoint(self.build_request_payload(input_df), {"ContentType": 'text/csv'})
