/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.futures;

import com.dataiku.dip.utils.DKULogger;

public class FutureProgressState {
    public final String name;
    public StateUnit unit;
    public double target;
    public double cur;
    public boolean important;
    public final int depth;
    private long startTimestamp;
    public long msSinceStart;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.futures.thread");

    public FutureProgressState(String name, int depth) {
        this(name, StateUnit.NONE, -1.0, depth);
    }

    public FutureProgressState(String name, StateUnit unit, int depth) {
        this(name, unit, -1.0, depth);
    }

    public FutureProgressState(String name, StateUnit unit, double target, int depth) {
        this.name = name;
        this.unit = unit;
        this.target = target;
        this.cur = 0.0;
        this.depth = depth;
        this.startTimestamp = System.currentTimeMillis();
        this.msSinceStart = 0L;
    }

    private FutureProgressState(String name, StateUnit unit, double target, double cur, boolean important, int depth, long startTimestamp) {
        this(name, unit, target, depth);
        this.cur = cur;
        this.important = important;
        this.startTimestamp = startTimestamp;
        this.msSinceStart = System.currentTimeMillis() - this.startTimestamp;
    }

    public void setTarget(long target) {
        this.target = target;
    }

    public synchronized void increment(double amount) throws InterruptedException {
        this.cur += amount;
        FutureProgressState.checkInterrupt();
    }

    public synchronized void set(double amount) throws InterruptedException {
        this.cur = amount;
        FutureProgressState.checkInterrupt();
    }

    public static void checkInterrupt() throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            logger.info((Object)("FutureProgress: thread " + String.valueOf(Thread.currentThread()) + " is interrupted, throwing"));
            throw new InterruptedException();
        }
    }

    public synchronized FutureProgressState getSnapshot() {
        return new FutureProgressState(this.name, this.unit, this.target, this.cur, this.important, this.depth, this.startTimestamp);
    }

    public static enum StateUnit {
        SIZE,
        FILES,
        RECORDS,
        NONE;

    }
}

