/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import java.util.Map;

public class GroupDiff {
    private static final List<String> OBFUSCATED_FIELDS = List.of();
    private JsonObject diff = new JsonObject();

    public JsonObject getDiff() {
        return this.diff;
    }

    public void addChange(String field, JsonElement oldValue, JsonElement newValue) {
        JsonObject change = new JsonObject();
        change.add("oldValue", oldValue);
        change.add("newValue", newValue);
        this.diff.add(field, (JsonElement)change);
    }

    public void addObfuscatedChange(String field) {
        JsonObject change = new JsonObject();
        change.add("oldValue", (JsonElement)new JsonPrimitive("xxxx"));
        change.add("newValue", (JsonElement)new JsonPrimitive("xxxx"));
        this.diff.add(field, (JsonElement)change);
    }

    public String toString() {
        return this.diff.toString();
    }

    public static GroupDiff calculateDiff(JsonObject oldGroup, JsonObject newGroup) {
        String key;
        GroupDiff groupDiff = new GroupDiff();
        for (Map.Entry entry : oldGroup.entrySet()) {
            key = (String)entry.getKey();
            JsonElement oldValue = (JsonElement)entry.getValue();
            JsonElement newValue = newGroup.get(key);
            if (newGroup.has(key) && oldValue.equals(newValue)) continue;
            if (OBFUSCATED_FIELDS.contains(key)) {
                groupDiff.addObfuscatedChange(key);
                continue;
            }
            groupDiff.addChange(key, oldValue, newValue);
        }
        for (Map.Entry entry : newGroup.entrySet()) {
            key = (String)entry.getKey();
            if (oldGroup.has(key)) continue;
            if (OBFUSCATED_FIELDS.contains(key)) {
                groupDiff.addObfuscatedChange(key);
                continue;
            }
            groupDiff.addChange(key, null, (JsonElement)entry.getValue());
        }
        return groupDiff;
    }
}

