/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.sso;

import com.dataiku.dip.coremodel.InfoMessage;

public enum OpenIDErrorCode implements InfoMessage.MessageCode
{
    ERR_OPENID_IDP_EXCHANGE_CODE_FAILURE("Exchange code failed", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_OPENID_IDP_INVALID_ID_TOKEN("Invalid ID Token", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_OPENID_SSO_UNKNOWN_USER("Unknown user", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_OPENID_IDP_INVALID_JWK_URI("Invalid JWK_URI", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_OPENID_IDP_INVALID_REDIRECT_URI("Invalid redirect URI", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_OPENID_SSO_DISABLED_USER("Disabled user", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_OPENID_INVALID_NONCE("ID token invalid nonce", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_OPENID_UNVERIFIED_EMAIL("ID token unverified email", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY),
    ERR_OPENID_PKCE_CODE_VERIFIER_MISSING("No code verifier was found for completing the PKCE OpenID flow", InfoMessage.FixabilityCategory.ADMIN_SETTINGS_SECURITY);

    private final String title;
    private final InfoMessage.FixabilityCategory fixability;

    private OpenIDErrorCode(String title, InfoMessage.FixabilityCategory fixability) {
        this.title = title;
        this.fixability = fixability;
    }

    public String getCode() {
        return this.name();
    }

    public String getCodeTitle() {
        return this.title;
    }

    public InfoMessage.FixabilityCategory getFixability() {
        return this.fixability;
    }
}

