/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.tickets;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.tickets.AbstractAPITicketService;
import com.dataiku.dip.security.tickets.BackendAPITicketExpiredEvent;
import com.dataiku.dip.server.services.IPubSubService;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BackendAPITicketService
extends AbstractAPITicketService {
    @Autowired
    private IPubSubService pubSubService;
    private Map<String, APITicketService.Ticket> tickets = Maps.newHashMap();
    private static DKULogger logger = DKULogger.getLogger((String)"dip.tickets");

    @Override
    public APITicketService.Ticket createTicket(AuthCtx authCtx, String description, Object payload) {
        String secret = SecretKeyGenerator.generate(64);
        return this.createTicketWithSecret(authCtx, description, payload, secret);
    }

    public APITicketService.ExpirableTicket createExpirableTicketWithKnownSecret(AuthCtx authCtx, String description, Object payload, String secret) {
        return new APITicketService.ExpirableTicket(this.createTicketWithSecret(authCtx, description, payload, secret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APITicketService.Ticket createTicketWithSecret(AuthCtx authCtx, String description, Object payload, String secret) {
        APITicketService.Ticket ticket = new APITicketService.Ticket().withId(description + "_" + SecretKeyGenerator.generate(12)).withSecret(secret).withUser(authCtx).withDescription(description).withPayload(payload);
        ticket.cruContext = CurrentComputeResourceUsageContext.get();
        logger.infoV("Creating API ticket for %s on behalf of %s id=%s", new Object[]{description, authCtx.getIdentifier(), ticket.getId()});
        BackendAPITicketService backendAPITicketService = this;
        synchronized (backendAPITicketService) {
            this.tickets.put(secret, ticket);
        }
        return ticket;
    }

    @Override
    public APITicketService.Ticket getSingleTicket() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public APITicketService.Ticket getTicket(String secret) throws IOException, DKUSecurityException {
        APITicketService.Ticket ticket;
        BackendAPITicketService backendAPITicketService = this;
        synchronized (backendAPITicketService) {
            ticket = this.tickets.get(secret);
        }
        if (ticket != null && ticket.refreshableAuthCtx) {
            ticket.user = ticket.user.refresh();
        }
        return ticket;
    }

    @Override
    public AuthCtx getTicketUser(String secret) throws IOException, DKUSecurityException {
        APITicketService.Ticket ticket = this.getTicket(secret);
        return ticket == null ? null : ticket.getViaAuthCtx();
    }

    @Override
    public synchronized void expireTicket(APITicketService.Ticket ticket) {
        APITicketService.Ticket removed = this.tickets.remove(ticket.getSecret());
        if (removed == null) {
            logger.warn((Object)"Ticket not listed anymore. Expiring the same ticket several times?");
        } else {
            BackendAPITicketExpiredEvent event = new BackendAPITicketExpiredEvent(removed);
            this.pubSubService.publish(event);
            String onBehalf = removed.getViaAuthCtx() != null ? removed.getViaAuthCtx().getIdentifier() : (removed.getKey() != null ? removed.getKey().label : "????");
            logger.infoV("Destroying API ticket for %s on behalf of %s", new Object[]{removed.getDescription(), onBehalf});
            for (APITicketService.Ticket proxied : ticket.getTicketsObtainedUsingCookies().values()) {
                this.expireTicket(proxied);
            }
        }
    }

    public synchronized List<APITicketService.Ticket> getAllActiveTickets() {
        return Lists.newArrayList(this.tickets.values());
    }
}

