/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.tickets;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.security.tickets.AbstractAPITicketService;
import com.dataiku.dip.utils.DKULogger;
import java.io.Closeable;

public class SingleTicketService
extends AbstractAPITicketService
implements Closeable {
    private APITicketService.Ticket ticket;
    private static final DKULogger logger = DKULogger.getLogger((String)"dip.tickets.single");

    @Override
    public APITicketService.Ticket createTicket(AuthCtx authCtx, String description, Object payload) {
        return this.ticket;
    }

    @Override
    public APITicketService.Ticket getTicket(String secret) {
        APITicketService.Ticket singleTicket = this.getSingleTicket();
        if (singleTicket.getSecret().equals(secret)) {
            return singleTicket;
        }
        return null;
    }

    @Override
    public APITicketService.Ticket getSingleTicket() {
        if (this.ticket == null) {
            throw new IllegalArgumentException("No API ticket available, or service has been decommissioned");
        }
        return this.ticket;
    }

    @Override
    public AuthCtx getTicketUser(String secret) {
        APITicketService.Ticket singleTicket = this.getSingleTicket();
        if (singleTicket.getSecret().equals(secret)) {
            return singleTicket.getViaAuthCtx();
        }
        return null;
    }

    @Override
    public void expireTicket(APITicketService.Ticket ticket) {
    }

    @Override
    public void close() {
        this.ticket = null;
    }

    protected final void setTicket(AuthCtx authContext, String ticketSecret, String description) {
        this.ticket = new APITicketService.Ticket().withSecret(ticketSecret).withDescription(description).withUser(authContext);
    }

    public void setTicket(AuthCtx authContext, String ticketSecret) {
        logger.traceV("Setting single API ticket in auth context: %s", new Object[]{authContext.getIdentifier()});
        this.setTicket(authContext, ticketSecret, "remoteFuture");
    }

    public void clearTicket() {
        logger.trace((Object)"Clearing single API ticket");
        if (this.ticket == null) {
            logger.info((Object)"Ticket has already been cleared, or was never set.");
        } else {
            this.ticket = null;
        }
    }
}

