/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server;

import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpMethod;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.HttpURI;
import com.dataiku.dss.shadelib.org.eclipse.jetty.http.UriCompliance;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Handler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Request;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Response;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Callback;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JettyUtils {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.server");

    public static HttpConfiguration createHttpConfiguration() {
        HttpConfiguration config = new HttpConfiguration();
        config.setSendServerVersion(false);
        UriCompliance compliance = UriCompliance.from(EnumSet.of(UriCompliance.Violation.SUSPICIOUS_PATH_CHARACTERS, new UriCompliance.Violation[]{UriCompliance.Violation.ILLEGAL_PATH_CHARACTERS, UriCompliance.Violation.AMBIGUOUS_PATH_SEGMENT, UriCompliance.Violation.AMBIGUOUS_PATH_SEPARATOR, UriCompliance.Violation.AMBIGUOUS_PATH_ENCODING, UriCompliance.Violation.AMBIGUOUS_EMPTY_SEGMENT, UriCompliance.Violation.UTF16_ENCODINGS, UriCompliance.Violation.USER_INFO}));
        config.setUriCompliance(compliance);
        return config;
    }

    public static void addHandlers(Server server, ServletContextHandler servletContextHandler) {
        MethodFilterHandler handler = new MethodFilterHandler(HttpMethod.TRACE, HttpMethod.MOVE, HttpMethod.PROPFIND, HttpMethod.PROPPATCH);
        Handler.Sequence handlers = new Handler.Sequence(new Handler[]{handler, new EmptySegmentRewriteHandler((Handler)servletContextHandler)});
        server.setHandler((Handler)handlers);
        server.getContainedBeans(ServletHandler.class).forEach(h -> h.setDecodeAmbiguousURIs(true));
    }

    public static void consumeRequest(HttpServletRequest req) throws IOException {
        IOUtils.consume((InputStream)req.getInputStream());
    }

    public static class MethodFilterHandler
    extends Handler.Wrapper {
        private final Set<String> forbiddenMethods = new HashSet<String>();

        public MethodFilterHandler(HttpMethod ... methods) {
            for (HttpMethod method : methods) {
                this.forbiddenMethods.add(method.name());
            }
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            if (this.forbiddenMethods.contains(request.getMethod())) {
                logger.warn((Object)("Rejecting forbidden HTTP method: " + request.getMethod()));
                response.setStatus(405);
                callback.succeeded();
                return true;
            }
            return super.handle(request, response, callback);
        }
    }

    public static class EmptySegmentRewriteHandler
    extends Handler.Wrapper {
        public EmptySegmentRewriteHandler(Handler handler) {
            super(handler);
        }

        public boolean handle(Request request, Response response, Callback callback) throws Exception {
            if (request.getHttpURI().hasViolation(UriCompliance.Violation.AMBIGUOUS_EMPTY_SEGMENT)) {
                request = this.rewriteRequest(request);
            }
            return super.handle(request, response, callback);
        }

        Request rewriteRequest(Request request) {
            HttpURI rewrite = this.rewriteHttpURL(request);
            return Request.serveAs((Request)request, (HttpURI)rewrite);
        }

        private HttpURI rewriteHttpURL(Request base) {
            String param = base.getHttpURI().getParam();
            String query = base.getHttpURI().getQuery();
            List<String> segments = Arrays.stream(base.getHttpURI().getPath().split("/")).filter(v -> !v.isEmpty()).toList();
            String newPath = "/" + StringUtils.join(segments, (String)"/");
            return HttpURI.build((HttpURI)base.getHttpURI(), (String)newPath, (String)param, (String)query).asImmutable();
        }
    }
}

