/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Pair;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DkuGraphiteReportingService {
    @Autowired
    TransactionService transactionService;
    private GraphiteReporter reporter = null;
    private String graphiteServerUrl = "";
    private String graphiteMetricPrefix = "";
    private int graphiteReportingDelay = 0;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.graphite.report");

    @PostConstruct
    private void start() {
        logger.debug((Object)"Init Graphite service");
        try (Transaction t = this.transactionService.beginRead();){
            this.restartReporterIfNeeded();
        }
        catch (IOException e) {
            logger.warn((Object)"Could not start Graphite reporting", (Throwable)e);
        }
        logger.debug((Object)"Done init Graphite service");
    }

    protected abstract GraphiteSettings loadGraphiteSettings() throws IOException;

    public void restartReporterIfNeeded() throws IOException {
        logger.info((Object)"Check if Graphite reporting needs to be (re)started");
        GraphiteSettings graphiteSettings = this.loadGraphiteSettings();
        String newGraphiteServerUrl = graphiteSettings.graphiteServerUrl;
        String newGraphiteMetricPrefix = graphiteSettings.graphiteMetricPrefix;
        if (StringUtils.isBlank((String)newGraphiteServerUrl)) {
            newGraphiteServerUrl = "";
        }
        if (StringUtils.isBlank((String)newGraphiteMetricPrefix)) {
            newGraphiteMetricPrefix = "";
        }
        if (!newGraphiteMetricPrefix.equals(this.graphiteMetricPrefix) || !newGraphiteServerUrl.equals(this.graphiteServerUrl) || graphiteSettings.graphiteReportingDelay != this.graphiteReportingDelay) {
            this.graphiteMetricPrefix = newGraphiteMetricPrefix;
            this.graphiteServerUrl = newGraphiteServerUrl;
            this.graphiteReportingDelay = graphiteSettings.graphiteReportingDelay;
            if (this.reporter != null) {
                logger.info((Object)"Stop current Graphite reporter");
                this.reporter.stop();
                this.reporter = null;
            }
            if (StringUtils.isNotBlank((String)this.graphiteServerUrl) && this.graphiteReportingDelay > 0) {
                logger.info((Object)("Start reporting to Graphite on " + this.graphiteServerUrl + " every " + this.graphiteReportingDelay + "min"));
                String graphitePrefix = DkuGraphiteReportingService.getPrefix(this.graphiteMetricPrefix);
                Pair<String, Integer> hostPort = DkuGraphiteReportingService.getUrl(this.graphiteServerUrl);
                if (StringUtils.isNotBlank((String)((String)hostPort.first))) {
                    Graphite graphite = new Graphite((String)hostPort.first, ((Integer)hostPort.second).intValue());
                    this.reporter = GraphiteReporter.forRegistry((MetricRegistry)DSSMetrics.registry()).prefixedWith(graphitePrefix + ".server").convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).filter(MetricFilter.ALL).build(graphite);
                    this.reporter.start((long)this.graphiteReportingDelay, TimeUnit.MINUTES);
                } else {
                    logger.warn((Object)("Impossible to parse Graphite url: " + this.graphiteServerUrl));
                }
            }
        }
    }

    public static Pair<String, Integer> getUrl(String graphiteUrl) {
        int port = -1;
        String host = null;
        try {
            if (!Pattern.matches("[a-zA-Z0-9]+\\:\\/\\/", (CharSequence)graphiteUrl)) {
                graphiteUrl = "http://" + (String)graphiteUrl;
            }
            URL url = new URL((String)graphiteUrl);
            port = url.getPort();
            host = url.getHost();
            if (port < 0) {
                port = 2003;
            }
        }
        catch (MalformedURLException e) {
            logger.warn((Object)("Incorrect url to Graphite server : " + (String)graphiteUrl), (Throwable)e);
        }
        return new Pair(host, (Object)port);
    }

    public static String getPrefix(String graphitePrefix) {
        if (StringUtils.isBlank((String)graphitePrefix)) {
            graphitePrefix = "dss." + DKUApp.dipInstanceId();
        }
        if (((String)graphitePrefix).endsWith(".")) {
            graphitePrefix = ((String)graphitePrefix).substring(0, ((String)graphitePrefix).length() - 1);
        }
        return graphitePrefix;
    }

    protected static class GraphiteSettings {
        @Nullable
        private final String graphiteServerUrl;
        @Nullable
        private final String graphiteMetricPrefix;
        private final int graphiteReportingDelay;

        public GraphiteSettings(@Nullable String graphiteServerUrl, @Nullable String graphiteMetricPrefix, int graphiteReportingDelay) {
            this.graphiteServerUrl = graphiteServerUrl;
            this.graphiteMetricPrefix = graphiteMetricPrefix;
            this.graphiteReportingDelay = graphiteReportingDelay;
        }
    }
}

