/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.j3ts.PyMappedType;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

class PyFileEmitter {
    public final RelFile definitionFileNameNoExt;
    private final Map<PyMappedType, Boolean> imports = new HashMap<PyMappedType, Boolean>();
    private final StringBuilder definitionsBuffer = new StringBuilder();
    public static Set<String> pythonKeywords = Set.of("False", "await", "else", "import", "pass", "None", "break", "except", "in", "raise", "True", "class", "finally", "is", "return", "and", "continue", "for", "lambda", "try", "as", "def", "from", "nonlocal", "while", "assert", "del", "global", "not", "with", "async", "elif", "if", "or", "yield");
    public static LinkedHashSet<String> typingImports = new LinkedHashSet<String>(List.of("List", "Dict", "Any", "TypedDict", "Literal", "NotRequired", "Optional", "TypeVar", "Generic", "Union", "Final", "TypeIs", "TYPE_CHECKING"));

    public PyFileEmitter(RelFile definitionFileNameNoExt) {
        this.definitionFileNameNoExt = definitionFileNameNoExt;
    }

    private List<String> synthesizeImportStatements(PyMappedType mt) {
        ArrayList<String> out = new ArrayList<String>();
        if (mt.type == PyMappedType.PyType.CLASS || mt.type == PyMappedType.PyType.ENUM) {
            if (this.definitionFileNameNoExt.equals(mt.definitionFileNoExt)) {
                return out;
            }
            Object from = "." + String.valueOf(new File("." + String.valueOf(this.definitionFileNameNoExt)).getParentFile().toPath().relativize(new File("." + String.valueOf(mt.definitionFileNoExt)).toPath()));
            from = ((String)from).replace("../", ".").replace("/", ".");
            if (mt.type == PyMappedType.PyType.ENUM) {
                out.add("from " + (String)from + " import " + mt.getName());
            }
            if (mt.type == PyMappedType.PyType.CLASS) {
                out.add("from " + (String)from + " import " + mt.getName() + ", " + mt.getNameForInterface());
            }
        }
        return out;
    }

    private Set<String> dedupImports(Set<PyMappedType> imports) {
        return imports.stream().filter(mt -> mt.definitionFileNoExt != null && !mt.definitionFileNoExt.equals(this.definitionFileNameNoExt)).flatMap(mt -> this.synthesizeImportStatements((PyMappedType)mt).stream()).collect(Collectors.toCollection(HashSet::new));
    }

    private Imports dedupImports(Map<PyMappedType, Boolean> imports) {
        HashSet<PyMappedType> unconditionalImports = new HashSet<PyMappedType>();
        HashSet<PyMappedType> typingHintImports = new HashSet<PyMappedType>();
        for (Map.Entry<PyMappedType, Boolean> e : imports.entrySet()) {
            if (e.getValue().booleanValue()) {
                unconditionalImports.add(e.getKey());
                continue;
            }
            typingHintImports.add(e.getKey());
        }
        return new Imports(this.dedupImports(unconditionalImports), this.dedupImports(typingHintImports));
    }

    public String generateCode() {
        Imports dedupedImportStatements = this.dedupImports(this.imports);
        ArrayList<String> out = new ArrayList<String>(dedupedImportStatements.typingHintImports);
        ArrayList<String> outUnconditional = new ArrayList<String>(dedupedImportStatements.unconditionalImports);
        Collections.sort(out);
        Collections.sort(outUnconditional);
        StringBuilder outputBuffer = new StringBuilder();
        outputBuffer.append("from typing_extensions import ").append(String.join((CharSequence)", ", typingImports)).append("\n");
        if (!out.isEmpty()) {
            outputBuffer.append("if TYPE_CHECKING:\n");
        }
        for (String line : out) {
            outputBuffer.append("    ").append(line).append("\n");
        }
        for (String line : outUnconditional) {
            outputBuffer.append(line).append("\n");
        }
        outputBuffer.append("\n");
        outputBuffer.append((CharSequence)this.definitionsBuffer);
        outputBuffer.append("\n# EOF");
        return outputBuffer.toString().trim() + "\n";
    }

    public void addImport(PyMappedType mt, boolean unconditionalImport) {
        if (!this.imports.containsKey(mt) || !this.imports.get(mt).booleanValue()) {
            this.imports.put(mt, unconditionalImport);
        }
    }

    private void writeTypeReference(PyMappedType mt, PyMappedType rootType) {
        this.writeTypeReference(mt, rootType, false, false);
    }

    private void writeTypeReference(PyMappedType mt, PyMappedType rootType, boolean forceReferenceInterface, boolean disableStringification) {
        if (mt.type == PyMappedType.PyType.CLASS) {
            String name = mt.getName();
            if (rootType != null && name.equals(rootType.getName()) || forceReferenceInterface) {
                name = mt.getNameForInterface();
            }
            if (!disableStringification) {
                this.write("'");
            }
            this.write(name);
            if (!disableStringification) {
                this.write("'");
            }
            this.addImport(mt, disableStringification);
        } else if (mt.type == PyMappedType.PyType.ENUM) {
            if (!disableStringification) {
                this.write("'");
            }
            this.write(mt.getName());
            if (!disableStringification) {
                this.write("'");
            }
            this.addImport(mt, disableStringification);
        } else if (mt.type == PyMappedType.PyType.STRING) {
            this.write("str");
        } else if (mt.type == PyMappedType.PyType.INT) {
            this.write("int");
        } else if (mt.type == PyMappedType.PyType.FLOAT) {
            this.write("float");
        } else if (mt.type == PyMappedType.PyType.LIST) {
            this.write("List[");
            this.writeTypeReference(mt.typeParameters.get(0), rootType, false, disableStringification);
            this.write("]");
        } else if (mt.type == PyMappedType.PyType.MAP) {
            this.write("Dict[");
            this.writeTypeReference(mt.typeParameters.get(0), rootType, false, disableStringification);
            this.write(", ");
            this.writeTypeReference(mt.typeParameters.get(1), rootType, false, disableStringification);
            this.write("]");
        } else if (mt.type == PyMappedType.PyType.BOOLEAN) {
            this.write("bool");
        } else if (mt.type == PyMappedType.PyType.ANY) {
            this.write("Any");
        } else if (mt.type == PyMappedType.PyType.PARAMETRIZED_TYPE) {
            if (!disableStringification) {
                this.write("'");
            }
            this.writeTypeReference(mt.rawJavaType, rootType, true, true);
            this.write("[");
            boolean first = true;
            for (PyMappedType typeParameter : mt.typeParameters) {
                if (!first) {
                    this.write(", ");
                }
                this.writeTypeReference(typeParameter, rootType, false, true);
                first = false;
            }
            this.write("]");
            if (!disableStringification) {
                this.write("'");
            }
        } else if (mt.type == PyMappedType.PyType.TYPE_VARIABLE) {
            this.write(mt.getName());
        } else if (mt.type == PyMappedType.PyType.UNKNOWN) {
            this.write("object");
        } else {
            throw new RuntimeException("Unknown type " + String.valueOf((Object)mt.type));
        }
    }

    public void writeTypeDefinition(PyMappedType mt) {
        if (mt.type != PyMappedType.PyType.ENUM && mt.type != PyMappedType.PyType.CLASS) {
            return;
        }
        if (mt.type == PyMappedType.PyType.CLASS) {
            this.write("'''\n");
            this.write("Translated from ");
            this.write(mt.javaType.toString());
            this.write("\n");
            this.write("Via: ");
            this.write(mt.explainTranslation());
            this.write("\n");
            if (mt.problem != null) {
                this.write(mt.problem + "\n");
            }
            this.write("'''\n\n");
            boolean requireFunctionalSyntax = this.requireFunctionalSyntax(mt);
            if (requireFunctionalSyntax) {
                this.write(mt.getNameForFunctionalSyntax() + " = TypedDict('" + mt.getNameForFunctionalSyntax() + "', {\n");
                if (mt.polyJsonMeta != null && mt.polyJsonType != null && (mt.typeFields == null || mt.typeFields.stream().noneMatch(mf -> mf.name.equals(mt.polyJsonMeta.getTypeProperty()))) && this.requireFunctionalSyntax(mt.polyJsonMeta.getTypeProperty())) {
                    this.write("    '" + mt.polyJsonMeta.getTypeProperty() + "': ");
                    this.write("Literal[" + JSON.gson().toJson((Object)mt.polyJsonType) + "],\n");
                }
                if (mt.typeFields != null) {
                    for (PyMappedType.MappedField mf2 : mt.typeFields) {
                        if (!this.requireFunctionalSyntax(mf2.name)) continue;
                        this.write("    '");
                        this.write(mf2.name);
                        this.write("': ");
                        if (mf2.optional) {
                            this.write("NotRequired[Optional[");
                        }
                        this.writeTypeReference(mf2.mt, mt);
                        if (mf2.optional) {
                            this.write("]]");
                        }
                        this.write(",\n");
                    }
                }
                this.write("})\n");
                this.write("\n");
            }
            if (!mt.typeParameters.isEmpty()) {
                for (PyMappedType typeParam : mt.typeParameters) {
                    this.write(typeParam.getName() + " = TypeVar('" + typeParam.getName() + "')\n");
                }
                this.write("\n");
            }
            String baseClass = requireFunctionalSyntax ? mt.getNameForFunctionalSyntax() : "TypedDict";
            this.write("\n");
            this.write("class " + mt.getNameForInterface() + "(");
            String extra = null;
            if (mt.rawSuperclass != null) {
                if (mt.rawSuperclass.type == PyMappedType.PyType.CLASS) {
                    this.writeTypeReference(mt.superclass, mt, true, true);
                    this.write(", ");
                } else {
                    extra = "# Unable to extend " + String.valueOf(mt.rawSuperclass.javaType) + "\n";
                }
            }
            if (!mt.implementedInterfaces.isEmpty()) {
                for (int i = 0; i < mt.implementedInterfaces.size(); ++i) {
                    this.writeTypeReference(mt.implementedInterfaces.get(i), mt, true, true);
                    this.write(", ");
                }
            }
            if (!mt.typeParameters.isEmpty()) {
                this.write("Generic[");
                this.write(mt.typeParameters.stream().map(PyMappedType::getName).collect(Collectors.joining(", ")));
                this.write("], ");
            }
            this.write(baseClass);
            this.write("):\n");
            boolean hasSomeFields = false;
            if (mt.polyJsonMeta != null && mt.polyJsonType != null && (mt.typeFields == null || mt.typeFields.stream().noneMatch(mf -> mf.name.equals(mt.polyJsonMeta.getTypeProperty()))) && !this.requireFunctionalSyntax(mt.polyJsonMeta.getTypeProperty())) {
                this.write("    " + mt.polyJsonMeta.getTypeProperty() + ": ");
                this.write("Literal[" + JSON.gson().toJson((Object)mt.polyJsonType) + "]\n");
                hasSomeFields = true;
            }
            if (mt.typeFields != null) {
                for (PyMappedType.MappedField mappedField : mt.typeFields) {
                    if (this.requireFunctionalSyntax(mappedField.name)) continue;
                    this.write("    ");
                    this.write(mappedField.name);
                    this.write(": ");
                    if (mappedField.optional) {
                        this.write("NotRequired[Optional[");
                    }
                    this.writeTypeReference(mappedField.mt, mt);
                    if (mappedField.optional) {
                        this.write("]]");
                    }
                    this.write("\n");
                    hasSomeFields = true;
                }
            }
            if (!hasSomeFields) {
                this.write("    pass\n");
            }
            if (extra != null) {
                this.write(extra);
            }
            this.write("\n\n");
            if (mt.generateUnion && !mt.subclasses.isEmpty()) {
                List concreteSubclasses = mt.listHierarchyRecursivelyIncludingSelf().stream().filter(t -> t.concrete).collect(Collectors.toList());
                this.write("# ");
                this.write("List of all concrete subclasses of ");
                this.write(mt.javaType.getTypeName());
                this.write("\n");
                this.write(mt.getName());
                this.write(" = Union[");
                if (concreteSubclasses.size() == 1) {
                    this.writeTypeReference((PyMappedType)concreteSubclasses.get(0), mt);
                } else {
                    this.write("\n");
                    for (PyMappedType subclass : concreteSubclasses) {
                        this.write("    ");
                        this.writeTypeReference(subclass, mt);
                        this.write(",\n");
                    }
                }
                this.write("]\n\n");
            } else {
                if (!mt.generateUnion && mt.hasJavaSubclasses) {
                    this.write("#    ");
                    this.write("Translate from ");
                    this.write(mt.javaType.toString());
                    this.write("\n");
                    this.write("#    ");
                    this.write("@deprecated Translation is incomplete: annotate it with PyModel to generate a union of all concrete subclasses");
                    this.write("\n");
                }
                this.write(mt.getName());
                this.write(" = _");
                this.write(mt.getName());
                this.write("\n\n");
            }
            if (mt.polyJsonSubclasses != null && !mt.polyJsonSubclasses.isEmpty() && mt.polyJsonType == null) {
                this.write("# Types of ");
                this.write(mt.javaType.toString());
                this.write(" in PolyJSON mappings (as literal type)\n");
                this.write(mt.getName() + StringUtils.capitalize((String)mt.polyJsonMeta.getTypeProperty()) + "Literal");
                this.write(" = Literal[");
                for (PyMappedType pyMappedType : mt.polyJsonSubclasses) {
                    this.write(JSON.gson().toJson((Object)pyMappedType.polyJsonType));
                    this.write(", ");
                }
                this.write("]\n\n");
            }
        }
        if (mt.type == PyMappedType.PyType.ENUM) {
            this.write("'''\n");
            this.write("Translated from enum ");
            this.write(mt.javaType.getTypeName());
            this.write("\n");
            this.write("Via: ");
            this.write(mt.explainTranslation());
            this.write("\n");
            if (mt.problem != null) {
                this.write("# " + mt.problem + "\n");
            }
            this.write("'''\n\n");
            this.write(mt.getName() + " = Literal[\n");
            for (PyMappedType.MappedEnumValue enumValue : mt.enumValues) {
                this.write("    ");
                this.write("'");
                this.write(enumValue.value);
                this.write("',\n");
            }
            this.write("]\n\n");
        }
    }

    public static String pascalToSnake(String str) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isUpperCase(ch) || Character.isDigit(ch)) {
                if (i > 0) {
                    boolean previousCharIsLowerCase = Character.isLowerCase(str.charAt(i - 1));
                    boolean nextCharIsLowerCase = false;
                    if (i != str.length() - 1) {
                        nextCharIsLowerCase = Character.isLowerCase(str.charAt(i + 1));
                    }
                    if (previousCharIsLowerCase || nextCharIsLowerCase) {
                        result.append('_');
                    }
                }
                result.append(Character.toLowerCase(ch));
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }

    private void write(String str) {
        this.definitionsBuffer.append(str);
    }

    private boolean requireFunctionalSyntax(PyMappedType mappedType) {
        return mappedType.typeFields != null && mappedType.typeFields.stream().anyMatch(mf -> this.requireFunctionalSyntax(mf.name)) || mappedType.polyJsonMeta != null && this.requireFunctionalSyntax(mappedType.polyJsonMeta.getTypeProperty());
    }

    private boolean requireFunctionalSyntax(String name) {
        return pythonKeywords.contains(name);
    }

    private static class Imports {
        public Set<String> unconditionalImports;
        public Set<String> typingHintImports;

        public Imports(Set<String> unconditionalImports, Set<String> typingHintImports) {
            this.unconditionalImports = unconditionalImports;
            this.typingHintImports = typingHintImports;
        }
    }
}

