/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.CharArraySet;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.ConditionalTokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.ConditionalTokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.miscellaneous.ProtectedTermFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;

public class ProtectedTermFilterFactory
extends ConditionalTokenFilterFactory {
    public static final String NAME = "protectedTerm";
    public static final String PROTECTED_TERMS = "protected";
    public static final char FILTER_ARG_SEPARATOR = '.';
    public static final char FILTER_NAME_ID_SEPARATOR = '-';
    private final String termFiles;
    private final boolean ignoreCase;
    private final String wrappedFilters;
    private CharArraySet protectedTerms;

    public ProtectedTermFilterFactory(Map<String, String> args2) {
        super(args2);
        this.termFiles = this.require(args2, PROTECTED_TERMS);
        this.ignoreCase = this.getBoolean(args2, "ignoreCase", false);
        this.wrappedFilters = this.get(args2, "wrappedFilters");
        if (this.wrappedFilters != null) {
            this.handleWrappedFilterArgs(args2);
        }
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public ProtectedTermFilterFactory() {
        throw ProtectedTermFilterFactory.defaultCtorException();
    }

    private void handleWrappedFilterArgs(Map<String, String> args2) {
        LinkedHashMap<String, Map<String, String>> wrappedFilterArgs = new LinkedHashMap<String, Map<String, String>>();
        this.splitAt(',', this.wrappedFilters).forEach(filterName -> {
            if (wrappedFilterArgs.containsKey(filterName = filterName.trim().toLowerCase(Locale.ROOT))) {
                throw new IllegalArgumentException("wrappedFilters contains duplicate '" + filterName + "'. Add unique '-id' suffixes (stripped prior to SPI lookup).");
            }
            wrappedFilterArgs.put((String)filterName, new HashMap());
        });
        Iterator<Map.Entry<String, String>> iterator2 = args2.entrySet().iterator();
        while (iterator2.hasNext()) {
            String filterName2;
            Map.Entry<String, String> entry = iterator2.next();
            String filterArgKey = entry.getKey();
            String argValue = entry.getValue();
            List<String> splitKey = this.splitAt('.', filterArgKey);
            if (splitKey.size() != 2 || !wrappedFilterArgs.containsKey(filterName2 = splitKey.get(0).toLowerCase(Locale.ROOT))) continue;
            Map filterArgs = wrappedFilterArgs.computeIfAbsent(filterName2, k -> new HashMap());
            String argKey = splitKey.get(1);
            filterArgs.put(argKey, argValue);
            iterator2.remove();
        }
        if (args2.isEmpty()) {
            this.populateInnerFilters(wrappedFilterArgs);
        }
    }

    private void populateInnerFilters(LinkedHashMap<String, Map<String, String>> wrappedFilterArgs) {
        ArrayList<TokenFilterFactory> innerFilters = new ArrayList<TokenFilterFactory>();
        wrappedFilterArgs.forEach((filterName, filterArgs) -> {
            int idSuffixPos = filterName.indexOf(45);
            if (idSuffixPos != -1) {
                filterName = filterName.substring(0, idSuffixPos);
            }
            innerFilters.add(TokenFilterFactory.forName(filterName, filterArgs));
        });
        this.setInnerFilters(innerFilters);
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public CharArraySet getProtectedTerms() {
        return this.protectedTerms;
    }

    @Override
    protected ConditionalTokenFilter create(TokenStream input, Function<TokenStream, TokenStream> inner) {
        return new ProtectedTermFilter(this.protectedTerms, input, inner);
    }

    @Override
    public void doInform(ResourceLoader loader) throws IOException {
        this.protectedTerms = this.getWordSet(loader, this.termFiles, this.ignoreCase);
    }
}

