/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.analysis.payloads;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenFilterFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.TokenStream;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.payloads.DelimitedPayloadTokenFilter;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.payloads.FloatEncoder;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.payloads.IdentityEncoder;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.payloads.IntegerEncoder;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.payloads.PayloadEncoder;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoader;
import com.dataiku.dss.shadelib.org.apache.lucene.util.ResourceLoaderAware;
import java.util.Map;

public class DelimitedPayloadTokenFilterFactory
extends TokenFilterFactory
implements ResourceLoaderAware {
    public static final String NAME = "delimitedPayload";
    public static final String ENCODER_ATTR = "encoder";
    public static final String DELIMITER_ATTR = "delimiter";
    private final String encoderClass;
    private final char delimiter;
    private PayloadEncoder encoder;

    public DelimitedPayloadTokenFilterFactory(Map<String, String> args2) {
        super(args2);
        this.encoderClass = this.require(args2, ENCODER_ATTR);
        this.delimiter = this.getChar(args2, DELIMITER_ATTR, '|');
        if (!args2.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args2);
        }
    }

    public DelimitedPayloadTokenFilterFactory() {
        throw DelimitedPayloadTokenFilterFactory.defaultCtorException();
    }

    @Override
    public DelimitedPayloadTokenFilter create(TokenStream input) {
        return new DelimitedPayloadTokenFilter(input, this.delimiter, this.encoder);
    }

    @Override
    public void inform(ResourceLoader loader) {
        this.encoder = this.encoderClass.equals("float") ? new FloatEncoder() : (this.encoderClass.equals("integer") ? new IntegerEncoder() : (this.encoderClass.equals("identity") ? new IdentityEncoder() : loader.newInstance(this.encoderClass, PayloadEncoder.class)));
    }
}

