/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.payloads;

import com.dataiku.dss.shadelib.org.apache.lucene.index.PostingsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.spans.SpanCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class PayloadSpanCollector
implements SpanCollector {
    private final Collection<byte[]> payloads = new ArrayList<byte[]>();

    @Override
    public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
        BytesRef payload = postings.getPayload();
        if (payload == null) {
            return;
        }
        byte[] bytes = new byte[payload.length];
        System.arraycopy(payload.bytes, payload.offset, bytes, 0, payload.length);
        this.payloads.add(bytes);
    }

    @Override
    public void reset() {
        this.payloads.clear();
    }

    public Collection<byte[]> getPayloads() {
        return this.payloads;
    }
}

