/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.FunctionValues;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.ValueSource;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public class ConstKnnByteVectorValueSource
extends ValueSource {
    private final byte[] vector;

    public ConstKnnByteVectorValueSource(byte[] constVector) {
        this.vector = Objects.requireNonNull(constVector, "constVector");
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        return new FunctionValues(){

            @Override
            public byte[] byteVectorVal(int doc) {
                return ConstKnnByteVectorValueSource.this.vector;
            }

            @Override
            public String strVal(int doc) {
                return Arrays.toString(ConstKnnByteVectorValueSource.this.vector);
            }

            @Override
            public String toString(int doc) throws IOException {
                return ConstKnnByteVectorValueSource.this.description() + "=" + this.strVal(doc);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstKnnByteVectorValueSource other = (ConstKnnByteVectorValueSource)o;
        return Arrays.equals(this.vector, other.vector);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getClass().hashCode(), Arrays.hashCode(this.vector));
    }

    @Override
    public String description() {
        return "ConstKnnByteVectorValueSource(" + Arrays.toString(this.vector) + ")";
    }
}

