/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn;

import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.Intervals;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.intervals.IntervalsSource;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.flexible.standard.nodes.intervalfn.IntervalFunction;
import java.io.IOException;
import java.util.regex.Pattern;

public class AnalyzedText
extends IntervalFunction {
    private final String term;

    public AnalyzedText(String term) {
        this.term = term;
    }

    @Override
    public IntervalsSource toIntervalSource(String field, Analyzer analyzer) {
        int gaps = 0;
        boolean ordered = true;
        try {
            return Intervals.analyzedText(this.term, analyzer, field, gaps, ordered);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        if (AnalyzedText.requiresQuotes(this.term)) {
            return "\"" + this.term + "\"";
        }
        return this.term;
    }

    static boolean requiresQuotes(String term) {
        return Pattern.compile("[\\s]").matcher(term).find();
    }
}

