/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queryparser.surround.query;

import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.MultiTerms;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Terms;
import com.dataiku.dss.shadelib.org.apache.lucene.index.TermsEnum;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.surround.query.SimpleTerm;
import com.dataiku.dss.shadelib.org.apache.lucene.util.BytesRef;
import java.io.IOException;

public class SrndTermQuery
extends SimpleTerm {
    private final String termText;

    public SrndTermQuery(String termText, boolean quoted) {
        super(quoted);
        this.termText = termText;
    }

    public String getTermText() {
        return this.termText;
    }

    public Term getLuceneTerm(String fieldName) {
        return new Term(fieldName, this.getTermText());
    }

    @Override
    public String toStringUnquoted() {
        return this.getTermText();
    }

    @Override
    public void visitMatchingTerms(IndexReader reader, String fieldName, SimpleTerm.MatchingTermVisitor mtv) throws IOException {
        TermsEnum termsEnum;
        TermsEnum.SeekStatus status;
        Terms terms = MultiTerms.getTerms(reader, fieldName);
        if (terms != null && (status = (termsEnum = terms.iterator()).seekCeil(new BytesRef(this.getTermText()))) == TermsEnum.SeekStatus.FOUND) {
            mtv.visitMatchingTerm(this.getLuceneTerm(fieldName));
        }
    }
}

