/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.cutters.ranges;

import com.dataiku.dss.shadelib.org.apache.lucene.internal.hppc.IntArrayList;
import com.dataiku.dss.shadelib.org.apache.lucene.sandbox.facet.cutters.ranges.LongRangeFacetCutter;

final class LongRangeNode {
    final LongRangeNode left;
    final LongRangeNode right;
    final long start;
    final long end;
    IntArrayList outputs;

    LongRangeNode(long start, long end, LongRangeNode left, LongRangeNode right) {
        this.start = start;
        this.end = end;
        this.left = left;
        this.right = right;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb, 0);
        return sb.toString();
    }

    private static void indent(StringBuilder sb, int depth) {
        sb.append("  ".repeat(depth));
    }

    public void addOutputs(LongRangeFacetCutter.LongRangeAndPos range) {
        if (this.start >= range.range().min && this.end <= range.range().max) {
            if (this.outputs == null) {
                this.outputs = new IntArrayList();
            }
            this.outputs.add(range.pos());
        } else if (this.left != null) {
            assert (this.right != null);
            this.left.addOutputs(range);
            this.right.addOutputs(range);
        }
    }

    private void toString(StringBuilder sb, int depth) {
        LongRangeNode.indent(sb, depth);
        if (this.left == null) {
            assert (this.right == null);
            sb.append("leaf: ").append(this.start).append(" to ").append(this.end);
        } else {
            sb.append("node: ").append(this.start).append(" to ").append(this.end);
        }
        if (this.outputs != null) {
            sb.append(" outputs=");
            sb.append(this.outputs);
        }
        sb.append('\n');
        if (this.left != null) {
            assert (this.right != null);
            this.left.toString(sb, depth + 1);
            this.right.toString(sb, depth + 1);
        }
    }
}

