/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dss.shadelibgcp.com.google.api.client.util.BackOff;
import com.dataiku.dss.shadelibgcp.com.google.api.client.util.ExponentialBackOff;
import java.io.IOException;

public interface BackOffStrategy {
    public static BackOffStrategy expBackOff(int initialWaitMs, int maxWaitMs, double multiplier) {
        return BackOffStrategy.expBackOff(initialWaitMs, maxWaitMs, multiplier, Integer.MAX_VALUE);
    }

    public static BackOffStrategy expBackOff(int initialWaitMs, int maxWaitMs, double multiplier, int timeoutMs) {
        return () -> new ExponentialBackOff.Builder().setMaxIntervalMillis(maxWaitMs).setInitialIntervalMillis(initialWaitMs).setMaxElapsedTimeMillis(timeoutMs).setMultiplier(multiplier).build();
    }

    public BackOff build();

    default public BackOffNoException buildNoException() {
        return new BackOffNoException(this.build());
    }

    public static class BackOffNoException {
        BackOff underlying;

        BackOffNoException(BackOff underlying) {
            this.underlying = underlying;
        }

        public long nextBackOffMillis() {
            try {
                return this.underlying.nextBackOffMillis();
            }
            catch (IOException e) {
                throw new RuntimeException("Backoff failed??", e);
            }
        }
    }
}

