/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.JF;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class JSONRedactor {
    public static RedactionConfigBuilder configBuilder() {
        return new RedactionConfigBuilder();
    }

    public static JsonObject redactObject(JsonObject o, RedactionConfig config) {
        return (JsonObject)JSONRedactor.redactRec((JsonElement)o, config);
    }

    public static JsonObject redactObject(Object o, RedactionConfig config) {
        return (JsonObject)JSONRedactor.redactRec((JsonElement)JSON.toJsonObject(o), config);
    }

    private static JsonElement redactRec(JsonElement e, RedactionConfig config) {
        if (e instanceof JsonObject) {
            JsonObject ret = new JsonObject();
            for (Map.Entry entry : ((JsonObject)e).entrySet()) {
                if (config.mustRedactKey((String)entry.getKey())) {
                    ret.add((String)entry.getKey(), JSONRedactor.redactedEquivalent((JsonElement)entry.getValue()));
                    continue;
                }
                ret.add((String)entry.getKey(), JSONRedactor.redactRec((JsonElement)entry.getValue(), config));
            }
            return ret;
        }
        if (e instanceof JsonArray) {
            JsonArray ret = new JsonArray();
            for (JsonElement entry : (JsonArray)e) {
                ret.add(JSONRedactor.redactRec(entry, config));
            }
            return ret;
        }
        return e;
    }

    private static JsonElement redactedEquivalent(JsonElement value) {
        if (value.isJsonObject()) {
            return JF.obj().with("REDACTED", "REDACTED").get();
        }
        if (value.isJsonPrimitive()) {
            JsonPrimitive p = value.getAsJsonPrimitive();
            if (p.isBoolean()) {
                return new JsonPrimitive("REDACTED_BOOLEAN");
            }
            if (p.isNumber()) {
                return new JsonPrimitive("REDACTED_NUMBER");
            }
            return new JsonPrimitive("REDACTED");
        }
        if (value.isJsonArray()) {
            JsonArray ret = new JsonArray();
            ret.add((JsonElement)new JsonPrimitive("<REDACTED_ARRAY>"));
            return ret;
        }
        return JsonNull.INSTANCE;
    }

    public static class RedactionConfigBuilder {
        private final RedactionConfig redactionConfig = new RedactionConfig();

        public RedactionConfigBuilder withRedactedKey(String redactedKey) {
            this.redactionConfig.redactedKeys.add(redactedKey);
            return this;
        }

        public RedactionConfigBuilder withRedactedKeyPattern(String redactedKeyPattern) {
            Pattern p = Pattern.compile(redactedKeyPattern);
            this.redactionConfig.redactedKeyPatterns.add(p);
            return this;
        }

        public RedactionConfig build() {
            return this.redactionConfig;
        }
    }

    public static class RedactionConfig {
        private final List<String> redactedKeys = new ArrayList<String>();
        private final List<Pattern> redactedKeyPatterns = new ArrayList<Pattern>();

        private RedactionConfig() {
        }

        private boolean mustRedactKey(String key) {
            if (this.redactedKeys.contains(key)) {
                return true;
            }
            for (Pattern p : this.redactedKeyPatterns) {
                if (!p.matcher(key).matches()) continue;
                return true;
            }
            return false;
        }
    }
}

