/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.PurchaseRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.PurchaseScheduledInstancesRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class PurchaseScheduledInstancesRequestMarshaller
implements Marshaller<Request<PurchaseScheduledInstancesRequest>, PurchaseScheduledInstancesRequest> {
    @Override
    public Request<PurchaseScheduledInstancesRequest> marshall(PurchaseScheduledInstancesRequest purchaseScheduledInstancesRequest) {
        if (purchaseScheduledInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<PurchaseScheduledInstancesRequest> request = new DefaultRequest<PurchaseScheduledInstancesRequest>(purchaseScheduledInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "PurchaseScheduledInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        request.addParameter("ClientToken", IdempotentUtils.resolveString(purchaseScheduledInstancesRequest.getClientToken()));
        SdkInternalList purchaseScheduledInstancesRequestPurchaseRequestsList = (SdkInternalList)purchaseScheduledInstancesRequest.getPurchaseRequests();
        if (!purchaseScheduledInstancesRequestPurchaseRequestsList.isEmpty() || !purchaseScheduledInstancesRequestPurchaseRequestsList.isAutoConstruct()) {
            int purchaseRequestsListIndex = 1;
            for (PurchaseRequest purchaseScheduledInstancesRequestPurchaseRequestsListValue : purchaseScheduledInstancesRequestPurchaseRequestsList) {
                if (purchaseScheduledInstancesRequestPurchaseRequestsListValue.getInstanceCount() != null) {
                    request.addParameter("PurchaseRequest." + purchaseRequestsListIndex + ".InstanceCount", StringUtils.fromInteger(purchaseScheduledInstancesRequestPurchaseRequestsListValue.getInstanceCount()));
                }
                if (purchaseScheduledInstancesRequestPurchaseRequestsListValue.getPurchaseToken() != null) {
                    request.addParameter("PurchaseRequest." + purchaseRequestsListIndex + ".PurchaseToken", StringUtils.fromString(purchaseScheduledInstancesRequestPurchaseRequestsListValue.getPurchaseToken()));
                }
                ++purchaseRequestsListIndex;
            }
        }
        return request;
    }
}

