/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.internal.SdkInternalList;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.ReportInstanceStatusRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class ReportInstanceStatusRequestMarshaller
implements Marshaller<Request<ReportInstanceStatusRequest>, ReportInstanceStatusRequest> {
    @Override
    public Request<ReportInstanceStatusRequest> marshall(ReportInstanceStatusRequest reportInstanceStatusRequest) {
        SdkInternalList reportInstanceStatusRequestReasonCodesList;
        SdkInternalList reportInstanceStatusRequestInstancesList;
        if (reportInstanceStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ReportInstanceStatusRequest> request = new DefaultRequest<ReportInstanceStatusRequest>(reportInstanceStatusRequest, "AmazonEC2");
        request.addParameter("Action", "ReportInstanceStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (reportInstanceStatusRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(reportInstanceStatusRequest.getDescription()));
        }
        if (reportInstanceStatusRequest.getEndTime() != null) {
            request.addParameter("EndTime", StringUtils.fromDate(reportInstanceStatusRequest.getEndTime()));
        }
        if (!(reportInstanceStatusRequestInstancesList = (SdkInternalList)reportInstanceStatusRequest.getInstances()).isEmpty() || !reportInstanceStatusRequestInstancesList.isAutoConstruct()) {
            int instancesListIndex = 1;
            for (String reportInstanceStatusRequestInstancesListValue : reportInstanceStatusRequestInstancesList) {
                if (reportInstanceStatusRequestInstancesListValue != null) {
                    request.addParameter("InstanceId." + instancesListIndex, StringUtils.fromString(reportInstanceStatusRequestInstancesListValue));
                }
                ++instancesListIndex;
            }
        }
        if (!(reportInstanceStatusRequestReasonCodesList = (SdkInternalList)reportInstanceStatusRequest.getReasonCodes()).isEmpty() || !reportInstanceStatusRequestReasonCodesList.isAutoConstruct()) {
            int reasonCodesListIndex = 1;
            for (String reportInstanceStatusRequestReasonCodesListValue : reportInstanceStatusRequestReasonCodesList) {
                if (reportInstanceStatusRequestReasonCodesListValue != null) {
                    request.addParameter("ReasonCode." + reasonCodesListIndex, StringUtils.fromString(reportInstanceStatusRequestReasonCodesListValue));
                }
                ++reasonCodesListIndex;
            }
        }
        if (reportInstanceStatusRequest.getStartTime() != null) {
            request.addParameter("StartTime", StringUtils.fromDate(reportInstanceStatusRequest.getStartTime()));
        }
        if (reportInstanceStatusRequest.getStatus() != null) {
            request.addParameter("Status", StringUtils.fromString(reportInstanceStatusRequest.getStatus()));
        }
        return request;
    }
}

