/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud;

import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.StringUtils;
import com.dataiku.fm.cloud.CloudCryptoService;
import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.VirtualNetwork;
import com.dataiku.fm.model.settings.CloudStaticData;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.codec.binary.Base64;

public class CloudInstanceServiceUtils {
    public static void fillFMInfo(CloudCryptoService cryptoService, BaseInstanceUserDataFMInfo fmInfo, FMSettings settings, LogicalInstance li, FMApp fmApp) {
        fmInfo.dssPort = li.getInstanceSettingsTemplate().getDssPort();
        fmInfo.fmServerURL = StringUtils.nullIfBlank((String)li.getVirtualNetwork().getFMVisibleURL()) == null ? settings.instanceVisibleURL : li.getVirtualNetwork().getFMVisibleURL();
        fmInfo.fmTenantId = li.getTenant().getId();
        fmInfo.logicalInstanceId = li.getId();
        fmInfo.agentSecret = cryptoService.decrypt(li.getTenant(), li.getPossiblyEncryptedAgentSecret());
        fmInfo.httpsStrategy = li.getVirtualNetwork().getHttpsStrategy();
        fmInfo.httpStrategy = li.getVirtualNetwork().getHttpStrategy();
        if (li.getVirtualNetwork().getHttpsStrategy() == VirtualNetwork.HTTPSStrategy.CUSTOM_CERTIFICATE && li.getSSLCertificateKeyStorageMode() == LogicalInstance.CustomCertificateKeyStorageMode.SELF_SIGNED) {
            fmInfo.httpsStrategy = VirtualNetwork.HTTPSStrategy.SELF_SIGNED;
        }
        fmInfo.dssNodeType = li.getDssNodeType();
        fmInfo.dssNodeId = li.getLabel();
        fmInfo.instanceType = fmApp.getCloudStaticData().instanceTypesSettings.getById(li.getCloudInstanceType());
        fmInfo.storiesEnabled = li.getInstanceSettingsTemplate().getStoriesEnabled();
    }

    public static String generateUserData(BaseInstanceUserDataFMInfo fm) throws MessagingException, IOException {
        MimeMultipart multiPart = new MimeMultipart();
        MimeBodyPart fmInfo = new MimeBodyPart();
        fmInfo.setFileName("fm-info.json");
        fmInfo.setText(JSON.json((Object)fm));
        multiPart.addBodyPart((BodyPart)fmInfo);
        Properties props = new Properties();
        Session session = Session.getInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session);
        msg.setContent((Multipart)multiPart);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)baos);
        return Base64.encodeBase64String((byte[])baos.toByteArray());
    }

    public static class BaseInstanceUserDataFMInfo {
        public Integer dssPort = 10000;
        public String fmServerURL;
        public String fmTenantId;
        public String logicalInstanceId;
        public String agentSecret;
        public String dssNodeType;
        public String dssNodeId;
        public CloudStaticData.CloudInstanceType instanceType;
        public VirtualNetwork.HTTPSStrategy httpsStrategy;
        public VirtualNetwork.HTTPStrategy httpStrategy;
        public List<String> domainNamesForCertificate = new ArrayList<String>();
        public boolean certbotStaging;
        public LogicalInstance.CustomCertificateKeyStorageMode sslCertificateKeyStorageMode;
        public String sslCertificatePEM;
        public String contactMail;
        public boolean storiesEnabled;
    }
}

