/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws;

import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.security.aws.AWSClientBrokerService;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.regions.Region;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.AcmClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.acm.AcmClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.Ec2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.ec2.Ec2ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.elasticloadbalancingv2.ElasticLoadBalancingV2ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.KmsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.kms.KmsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.Route53Client;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.route53.Route53ClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.StsClient;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.StsClientBuilder;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.model.Credentials;
import com.dataiku.dss.shadelibawssk2.software.amazon.awssdk.services.sts.model.GetSessionTokenRequest;
import com.dataiku.fm.cloud.aws.sdk.AcmClientWrapper;
import com.dataiku.fm.cloud.aws.sdk.Ec2ClientWrapper;
import com.dataiku.fm.cloud.aws.sdk.LoadBalancingClientWrapper;
import com.dataiku.fm.model.settings.AWSSettings;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.accounts.CloudAccountsService;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.ParametersAreNonnullByDefault;
import org.springframework.beans.factory.annotation.Autowired;

@ParametersAreNonnullByDefault
public class AWSClientService {
    @Autowired
    private CloudAccountsService accountService;
    @Autowired
    private DatabaseAccessService dbService;
    @Autowired
    private AWSClientBrokerService awsClientBrokerService;
    @Autowired
    FMApp fmApp;
    private final Cache<Account, Ec2Client> ec2ClientCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();
    private final Cache<Account, Route53Client> route53ClientCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();
    private final Cache<Optional<AuthenticationInfo>, KmsClient> kmsClientCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();
    private final Cache<Account, ElasticLoadBalancingV2Client> elasticLoadBalancingV2ClientCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();
    private final Cache<Account, AcmClient> acmClientCache = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();

    public Ec2Client getEC2Client(Account account) {
        try {
            return (Ec2Client)this.ec2ClientCache.get((Object)account, () -> {
                Ec2ClientBuilder builder = (Ec2ClientBuilder)((Ec2ClientBuilder)this.awsClientBrokerService.createEc2ClientBuilder().region(Region.of((String)account.region))).credentialsProvider(this.getCustomerCredentialsProvider(account.authenticationInfo));
                this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)builder);
                return (Ec2Client)builder.build();
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Route53Client getRoute53Client(Account account) {
        try {
            return (Route53Client)this.route53ClientCache.get((Object)account, () -> {
                Route53ClientBuilder builder = (Route53ClientBuilder)((Route53ClientBuilder)this.awsClientBrokerService.createRoute53ClientBuilder().region(Region.of((String)account.region))).credentialsProvider(this.getCustomerCredentialsProvider(account.authenticationInfo));
                this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)builder);
                return (Route53Client)builder.build();
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public KmsClient getKMSClient(Optional<AuthenticationInfo> authenticationInfo) {
        try {
            return (KmsClient)this.kmsClientCache.get(authenticationInfo, () -> {
                FMSettings settings = FMApp.getFMSettingsUnsafe();
                KmsClientBuilder builder = (KmsClientBuilder)((KmsClientBuilder)this.awsClientBrokerService.createKmsClientBuilder().region(Region.of((String)settings.awsSettings.regionId))).credentialsProvider(this.getCustomerCredentialsProvider(authenticationInfo));
                this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)builder);
                return (KmsClient)builder.build();
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public LoadBalancingClientWrapper getLoadBalancingClientWrapper(Account account) {
        return new LoadBalancingClientWrapper(this.getElasticLoadBalancingClient(account));
    }

    public Ec2ClientWrapper getEc2ClientWrapper(Account account) {
        return new Ec2ClientWrapper(this.getEC2Client(account));
    }

    public ElasticLoadBalancingV2Client getElasticLoadBalancingClient(Account account) {
        try {
            return (ElasticLoadBalancingV2Client)this.elasticLoadBalancingV2ClientCache.get((Object)account, () -> {
                ElasticLoadBalancingV2ClientBuilder builder = (ElasticLoadBalancingV2ClientBuilder)((ElasticLoadBalancingV2ClientBuilder)this.awsClientBrokerService.createElasticLoadBalancingV2ClientBuilder().region(Region.of((String)account.region))).credentialsProvider(this.getCustomerCredentialsProvider(account.authenticationInfo));
                this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)builder);
                return (ElasticLoadBalancingV2Client)builder.build();
            });
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public AcmClientWrapper getACMClient(Account account) {
        try {
            return new AcmClientWrapper((AcmClient)this.acmClientCache.get((Object)account, () -> {
                AcmClientBuilder builder = (AcmClientBuilder)((AcmClientBuilder)this.awsClientBrokerService.createAcmClientBuilder().region(Region.of((String)account.region))).credentialsProvider(this.getCustomerCredentialsProvider(account.authenticationInfo));
                this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)builder);
                return (AcmClient)builder.build();
            }));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public String getTenantAccountId(Optional<AuthenticationInfo> authenticationInfo) {
        StsClientBuilder stsClientBuilder = (StsClientBuilder)this.initializeStsClientBuilder().credentialsProvider(this.getCustomerCredentialsProvider(authenticationInfo));
        try (StsClient stsClient = (StsClient)stsClientBuilder.build();){
            String string = stsClient.getCallerIdentity().account();
            return string;
        }
    }

    private AwsCredentialsProvider getCustomerCredentialsProvider(Optional<AuthenticationInfo> authenticationInfoOptional) {
        return authenticationInfoOptional.map(this::getAWSCredentials).map(credentials -> AwsSessionCredentials.builder().accessKeyId(credentials.accessKeyId()).secretAccessKey(credentials.secretAccessKey()).sessionToken(credentials.sessionToken()).build()).map(StaticCredentialsProvider::create).orElse((AwsCredentialsProvider)DefaultCredentialsProvider.builder().build());
    }

    private Credentials getAWSCredentials(AuthenticationInfo authenticationInfo) {
        if (authenticationInfo instanceof IamRole) {
            IamRole iamRole = (IamRole)authenticationInfo;
            try (StsClient stsClient = (StsClient)this.initializeStsClientBuilder().build();){
                Credentials credentials = stsClient.assumeRole((AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(iamRole.arn).roleSessionName("fm-access").externalId((String)iamRole.externalId.orElse(null)).build()).credentials();
                return credentials;
            }
        }
        if (authenticationInfo instanceof KeyPair) {
            KeyPair keyPair = (KeyPair)authenticationInfo;
            StsClientBuilder stsClientBuilder = (StsClientBuilder)this.initializeStsClientBuilder().credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.builder().accessKeyId(keyPair.id).secretAccessKey(keyPair.secret).build()));
            try (StsClient stsClient = (StsClient)stsClientBuilder.build();){
                Credentials credentials = stsClient.getSessionToken((GetSessionTokenRequest)GetSessionTokenRequest.builder().durationSeconds(Integer.valueOf(3600)).build()).credentials();
                return credentials;
            }
        }
        throw new IllegalStateException("Unexpected authentication type: " + String.valueOf(authenticationInfo.getClass()));
    }

    private StsClientBuilder initializeStsClientBuilder() {
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        StsClientBuilder stsClientBuilder = (StsClientBuilder)((StsClientBuilder)this.awsClientBrokerService.createStsClientBuilder().region(Region.of((String)fmSettings.awsSettings.regionId))).endpointOverride(this.getSTSEndpointURI(fmSettings.awsSettings));
        this.conditionallyConfigureProxy((AwsSyncClientBuilder<?, ?>)stsClientBuilder);
        return stsClientBuilder;
    }

    private void conditionallyConfigureProxy(AwsSyncClientBuilder<?, ?> clientBuilder) {
        FMSettings fmSettings = FMApp.getFMSettingsUnsafe();
        if (this.fmApp.isCloudProxyEnabledWrapper(fmSettings)) {
            ProxyUtils.addHttpClientBuilderAndApplyProxySettings((ProxySettings)fmSettings.proxySettings, clientBuilder, (boolean)this.fmApp.isSSLVerificationDisabled());
        }
    }

    private URI getSTSEndpointURI(AWSSettings awsSettings) {
        return URI.create((String)(awsSettings.stsServiceEndpoint == null ? "https://sts." + awsSettings.regionId + ".amazonaws.com" : awsSettings.stsServiceEndpoint));
    }

    public record Account(String region, Optional<AuthenticationInfo> authenticationInfo) {
    }

    public record IamRole(String arn, Optional<String> externalId) implements AuthenticationInfo
    {
    }

    public record KeyPair(String id, String secret) implements AuthenticationInfo
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface AuthenticationInfo {
    }
}

