/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.aws;

import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.fm.cloud.VirtualNetworkMetadata;
import com.dataiku.fm.server.FMApp;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AWSInstanceMetadataReader {
    private static final Logger logger = Logger.getLogger((String)"dku.fm.aws.metadata");

    public VirtualNetworkMetadata getVirtualNetworkMetadata() {
        VirtualNetworkMetadata result = new VirtualNetworkMetadata();
        String imds_token = AWSInstanceMetadataReader.getIMDSToken();
        String mac = AWSInstanceMetadataReader.getLocalMetadata("/meta-data/network/interfaces/macs", imds_token).split("\n")[0];
        if (StringUtils.isNotBlank((String)mac)) {
            result.awsVpcId = AWSInstanceMetadataReader.getLocalMetadata("/meta-data/network/interfaces/macs/" + mac + "/vpc-id", imds_token).split("\n")[0];
            result.awsSubnetId = AWSInstanceMetadataReader.getLocalMetadata("/meta-data/network/interfaces/macs/" + mac + "/subnet-id", imds_token).split("\n")[0];
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getIMDSToken() {
        try {
            HttpURLConnection con;
            URL url = new URL("http://169.254.169.254/latest/api/token");
            if (FMApp.isCloudProxyEnabled()) {
                con = (HttpURLConnection)url.openConnection(FMApp.getFMSettingsUnsafe().proxySettings.getProxy());
                con.setAuthenticator(ProxyUtils.getProxyAuthenticator(() -> FMApp.getFMSettingsUnsafe().proxySettings));
            } else {
                con = (HttpURLConnection)url.openConnection();
            }
            con.setRequestMethod("PUT");
            con.setRequestProperty("X-aws-ec2-metadata-token-ttl-seconds", "21600");
            con.setConnectTimeout(15000);
            if (con.getResponseCode() != 200) {
                logger.warn((Object)("Unable to retrieve IMDS Token. ResponseCode: " + con.getResponseCode()));
                return "";
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                String string = response.toString();
                return string;
            }
        }
        catch (IOException e) {
            logger.warn((Object)"Unable to retrieve IMDS Token ", (Throwable)e);
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getLocalMetadata(String path, String token) {
        try {
            HttpURLConnection con;
            URL url = new URL("http://169.254.169.254/latest" + path);
            if (FMApp.isCloudProxyEnabled()) {
                con = (HttpURLConnection)url.openConnection(FMApp.getFMSettingsUnsafe().proxySettings.getProxy());
                con.setAuthenticator(ProxyUtils.getProxyAuthenticator(() -> FMApp.getFMSettingsUnsafe().proxySettings));
            } else {
                con = (HttpURLConnection)url.openConnection();
            }
            con.setRequestProperty("X-aws-ec2-metadata-token", token);
            con.setConnectTimeout(15000);
            if (con.getResponseCode() != 200) {
                logger.warn((Object)("Unable to retrieve local metadata " + path + " ResponseCode: " + con.getResponseCode()));
                return "";
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                String inputLine;
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                String string = response.toString();
                return string;
            }
        }
        catch (IOException e) {
            logger.warn((Object)("Unable to retrieve local metadata " + path), (Throwable)e);
            return "";
        }
    }
}

