/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.cloud.gcp;

import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.dataiku.dss.shadelibgcp.com.google.api.client.googleapis.util.Utils;
import com.dataiku.dss.shadelibgcp.com.google.api.client.http.HttpTransport;
import com.dataiku.dss.shadelibgcp.com.google.api.client.json.JsonFactory;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.GoogleCredentials;
import com.dataiku.dss.shadelibgcp.com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class GoogleCredentialBuilder {
    private static final Pattern JSON_PRIVATE_KEY_FILE_PATTERN = Pattern.compile(".*\\.json", 2);

    public static boolean isJson(String str) {
        String trimmed = str.trim();
        return trimmed.startsWith("{") && trimmed.endsWith("}");
    }

    public GoogleCredential build_v1(String gcpServiceAccountKeyOrKeyPath) {
        if (StringUtils.isBlank((String)gcpServiceAccountKeyOrKeyPath)) {
            try {
                return this.buildFromEnvironment_v1();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to extract private key from supplied JSON string.", e);
            }
        }
        if (GoogleCredentialBuilder.isJson(gcpServiceAccountKeyOrKeyPath)) {
            try {
                return this.buildFromJson_v1(new ByteArrayInputStream(gcpServiceAccountKeyOrKeyPath.getBytes(Charsets.UTF_8)));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to extract private key from supplied JSON string.", e);
            }
        }
        if (JSON_PRIVATE_KEY_FILE_PATTERN.matcher(gcpServiceAccountKeyOrKeyPath).matches()) {
            GoogleCredential googleCredential;
            FileInputStream stream = new FileInputStream(gcpServiceAccountKeyOrKeyPath);
            try {
                googleCredential = this.buildFromJson_v1(stream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to extract private key from supplied JSON file.", e);
                }
            }
            stream.close();
            return googleCredential;
        }
        throw new RuntimeException("Invalid secret key file path. Only .json and .p12 files are accepted.");
    }

    public GoogleCredentials build_v2(String gcpServiceAccountKeyOrKeyPath) {
        if (StringUtils.isBlank((String)gcpServiceAccountKeyOrKeyPath)) {
            try {
                return this.buildFromEnvironment_v2();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to extract private key from supplied JSON string.", e);
            }
        }
        if (GoogleCredentialBuilder.isJson(gcpServiceAccountKeyOrKeyPath)) {
            try {
                return this.buildFromJson_v2(new ByteArrayInputStream(gcpServiceAccountKeyOrKeyPath.getBytes(Charsets.UTF_8)));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to extract private key from supplied JSON string.", e);
            }
        }
        if (JSON_PRIVATE_KEY_FILE_PATTERN.matcher(gcpServiceAccountKeyOrKeyPath).matches()) {
            GoogleCredentials googleCredentials;
            FileInputStream stream = new FileInputStream(gcpServiceAccountKeyOrKeyPath);
            try {
                googleCredentials = this.buildFromJson_v2(stream);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to extract private key from supplied JSON file.", e);
                }
            }
            stream.close();
            return googleCredentials;
        }
        throw new RuntimeException("Invalid secret key file path. Only .json and .p12 files are accepted.");
    }

    public GoogleCredential buildFromJson_v1(InputStream stream) throws IOException {
        GoogleCredential credential = GoogleCredential.fromStream((InputStream)stream);
        if (credential.getServiceAccountId() == null) {
            throw new RuntimeException("Invalid private key. This is not a service account key or the 'client_email' field is missing.");
        }
        return credential;
    }

    private GoogleCredential buildFromEnvironment_v1() throws IOException {
        return GoogleCredential.getApplicationDefault((HttpTransport)Utils.getDefaultTransport(), (JsonFactory)Utils.getDefaultJsonFactory());
    }

    private GoogleCredentials buildFromJson_v2(InputStream stream) throws IOException {
        GoogleCredentials credential = GoogleCredentials.fromStream((InputStream)stream);
        if (!(credential instanceof ServiceAccountCredentials)) {
            throw new RuntimeException("Invalid private key. This is not a service account key (credentials=" + String.valueOf(credential) + ")");
        }
        return credential.createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform"});
    }

    public GoogleCredentials buildFromEnvironment_v2() throws IOException {
        return GoogleCredentials.getApplicationDefault();
    }
}

