/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model;

import com.dataiku.dip.utils.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;

public class SetupAction {
    public SetupActionType type;
    public boolean enabled = true;
    public JsonObject params = new JsonObject();
    public String description = null;

    public SetupAction(SetupActionType type) {
        this.type = type;
    }

    public boolean canBeReplayed() {
        if (this.type == SetupActionType.RUN_ANSIBLE_TASKS) {
            return this.isAnsibleAfterDSSStartup();
        }
        return this.type.isReplayable();
    }

    public boolean needRestart() {
        if (this.type == SetupActionType.RUN_ANSIBLE_TASKS) {
            return !this.isAnsibleAfterDSSStartup();
        }
        return this.type.needRestart();
    }

    private boolean isAnsibleAfterDSSStartup() {
        JsonElement jsonStage = this.params.get("stage");
        String stage = jsonStage == null ? null : jsonStage.getAsString();
        return "after_dss_startup".equalsIgnoreCase(stage);
    }

    static {
        JSON.registerAdapter(SetupAction.class, (Object)new JSON.Adapter<SetupAction>(){

            public SetupAction deserialize(JsonElement jsonElement, Type scriptType, JsonDeserializationContext jsonDeserializationContext) {
                SetupAction setupAction = (SetupAction)new Gson().fromJson(jsonElement, SetupAction.class);
                if (setupAction.type == null) {
                    setupAction.enabled = false;
                    return setupAction;
                }
                if (!((JsonObject)jsonElement).has("enabled")) {
                    setupAction.enabled = true;
                }
                return setupAction;
            }

            public JsonElement serialize(SetupAction task, Type type, JsonSerializationContext ctx) {
                return new Gson().toJsonTree((Object)task);
            }
        });
    }

    public static enum SetupActionType {
        RUN_ANSIBLE_TASKS(true, true),
        INSTALL_SYSTEM_PACKAGES(true, false),
        INSTALL_DSS_PLUGINS_FROM_STORE(false, false),
        SETUP_K8S_AND_SPARK(false, false),
        SETUP_RUNTIME_DATABASE(false, false),
        SETUP_MUS_AUTOCREATE(false, false),
        SETUP_UI_CUSTOMIZATION(false, false),
        SETUP_MEMORY_SETTINGS(false, false),
        SETUP_GRAPHICS_EXPORT(false, false),
        ADD_AUTHORIZED_KEY(true, false),
        INSTALL_JDBC_DRIVER(false, false),
        SETUP_ADVANCED_SECURITY(false, false),
        SETUP_INSTANCE_NAME(false, false),
        SETUP_SECURE_COOKIES(false, false),
        ADD_ENV_VARIABLES(true, true),
        ADD_PROPERTIES(true, true),
        ADD_SSH_KEY(true, false),
        ADD_CA_TO_TRUSTSTORE(true, true),
        SETUP_PROXY(true, true),
        INSTALL_CODE_ENV_WITH_PRESET(true, false),
        UPDATE_DSS_PORT(false, false),
        SETUP_NONE_K8S_AND_SPARK(false, false),
        INSTALL_DEPRECATED_PYTHON(true, false);

        private boolean isReplayable;
        private boolean needRestart;

        private SetupActionType(boolean isReplayable, boolean needRestart) {
            this.isReplayable = isReplayable;
            this.needRestart = needRestart;
        }

        public boolean isReplayable() {
            return this.isReplayable;
        }

        public boolean needRestart() {
            return this.needRestart;
        }
    }

    public static class SetupActionList
    extends ArrayList<SetupAction> {
        private static final long serialVersionUID = 1L;
    }
}

