/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.fm.model.db.CheckDefinition;
import com.dataiku.fm.model.db.CheckElementType;
import com.dataiku.fm.model.db.CheckState;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Entity(name="elementcheck")
public class ElementCheck {
    @Id
    private String id;
    @ManyToOne(fetch=FetchType.LAZY, optional=false)
    private CheckDefinition checkDefinition;
    @Enumerated(value=EnumType.STRING)
    private CheckElementType elementType;
    private String elementId;
    private boolean enabled = true;
    @Enumerated(value=EnumType.STRING)
    private CheckState checkState = CheckState.OK;
    private long lastStatusChangeTimestamp;
    private Long lastKoNotificationTimestamp;
    private Long failureFirstDetectedTimestamp;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Nonnull
    public CheckDefinition getCheckDefinition() {
        return this.checkDefinition;
    }

    public void setCheckDefinition(CheckDefinition checkDefinition) {
        this.checkDefinition = checkDefinition;
    }

    public CheckElementType getElementType() {
        return this.elementType;
    }

    public void setElementType(CheckElementType elementType) {
        this.elementType = elementType;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public CheckState getCheckState() {
        return this.checkState;
    }

    public void setCheckState(CheckState checkState) {
        this.checkState = checkState;
    }

    public long getLastStatusChangeTimestamp() {
        return this.lastStatusChangeTimestamp;
    }

    public void setLastStatusChangeTimestamp(long lastStatusChangeTimestamp) {
        this.lastStatusChangeTimestamp = lastStatusChangeTimestamp;
    }

    @Nullable
    public Long getLastKoNotificationTimestamp() {
        return this.lastKoNotificationTimestamp;
    }

    public void setLastKoNotificationTimestamp(long lastKoNotificationTimestamp) {
        this.lastKoNotificationTimestamp = lastKoNotificationTimestamp;
    }

    @Nullable
    public Long getFailureFirstDetectedTimestamp() {
        return this.failureFirstDetectedTimestamp;
    }

    public void setFailureFirstDetectedTimestamp(Long failureFirstDetectedTimestamp) {
        this.failureFirstDetectedTimestamp = failureFirstDetectedTimestamp;
    }

    public void updateState(CheckState checkState, long lastStatusChangeTimestamp) {
        this.checkState = checkState;
        this.lastStatusChangeTimestamp = lastStatusChangeTimestamp;
    }

    public String printForLogs() {
        Object s = "ElementCheck(";
        s = (String)s + "id=" + this.id;
        s = (String)s + ",checkType=" + this.checkDefinition.getType().name();
        s = (String)s + ",elementType=" + this.elementType.name();
        s = (String)s + ",elementId=" + this.elementId;
        s = (String)s + ",enabled=" + this.enabled;
        s = (String)s + ",state=" + String.valueOf((Object)this.checkState);
        s = (String)s + ",lastStatusChange=" + this.lastStatusChangeTimestamp;
        s = (String)s + ",lastKoNotification=" + this.lastKoNotificationTimestamp;
        s = (String)s + ")";
        return s;
    }
}

