/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.fm.model.db.LogicalInstance;
import com.dataiku.fm.model.db.LogicalLoadBalancer;
import com.dataiku.fm.model.db.PhysicalDNSRecord;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import java.util.Objects;
import javax.annotation.Nullable;

@Entity(name="loadbalancernodemapping")
public class LoadBalancerNodeMapping {
    @Id
    private String id;
    @ManyToOne
    @JoinColumn(name="logicalloadbalancer_id", nullable=true)
    private LogicalLoadBalancer logicalLoadBalancer;
    @ManyToOne
    @JoinColumn(name="logicalinstance_id", nullable=false)
    private LogicalInstance logicalInstance;
    @ManyToOne(cascade={CascadeType.ALL})
    private PhysicalDNSRecord publicPhysicalDNSRecord;
    @ManyToOne(cascade={CascadeType.ALL})
    private PhysicalDNSRecord privatePhysicalDNSRecord;
    @Column(name="hostname")
    private String subdomainOrFQDN;
    @Enumerated(value=EnumType.STRING)
    private Status status = Status.ACTIVE;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSubdomainOrFQDN() {
        return this.subdomainOrFQDN;
    }

    public void setSubdomainOrFQDN(String subdomainOrFQDN) {
        this.subdomainOrFQDN = subdomainOrFQDN;
    }

    @Nullable
    public LogicalLoadBalancer getLogicalLoadBalancer() {
        return this.logicalLoadBalancer;
    }

    public void setLogicalLoadBalancer(LogicalLoadBalancer logicalLoadBalancer) {
        this.logicalLoadBalancer = logicalLoadBalancer;
    }

    public LogicalInstance getLogicalInstance() {
        return this.logicalInstance;
    }

    public void setLogicalInstance(LogicalInstance logicalInstance) {
        this.logicalInstance = logicalInstance;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Nullable
    public PhysicalDNSRecord getPublicPhysicalDNSRecord() {
        return this.publicPhysicalDNSRecord;
    }

    public void setPublicPhysicalDNSRecord(PhysicalDNSRecord publicPhysicalDNSRecord) {
        this.publicPhysicalDNSRecord = publicPhysicalDNSRecord;
    }

    @Nullable
    public PhysicalDNSRecord getPrivatePhysicalDNSRecord() {
        return this.privatePhysicalDNSRecord;
    }

    public void setPrivatePhysicalDNSRecord(PhysicalDNSRecord privatePhysicalDNSRecord) {
        this.privatePhysicalDNSRecord = privatePhysicalDNSRecord;
    }

    public boolean isInstanceProvisioned() {
        return this.getLogicalInstance().getCurrentPhysicalInstance() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadBalancerNodeMapping that = (LoadBalancerNodeMapping)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.logicalLoadBalancer, that.logicalLoadBalancer) && Objects.equals(this.logicalInstance, that.logicalInstance) && Objects.equals(this.subdomainOrFQDN, that.subdomainOrFQDN);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.logicalLoadBalancer, this.logicalInstance, this.subdomainOrFQDN);
    }

    public static enum Status {
        ACTIVE,
        INACTIVE;

    }
}

