/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.model.db;

import com.dataiku.fm.cloud.azure.AzureInstanceMetadataReader;
import com.dataiku.fm.model.db.CloudAccount;
import com.dataiku.fm.model.published.CloudTagList;
import com.dataiku.fm.model.settings.FMSettings;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.Id;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;

@Entity(name="tenant")
public class Tenant {
    @Id
    private String id;
    private String label;
    @Column(columnDefinition="text")
    private String description;
    public String createdBy;
    public long creationDate;
    @Column(columnDefinition="text")
    private String cloudTags;
    @Enumerated(value=EnumType.STRING)
    private LicenseMode licenseMode;
    private String licenseToken;
    @Column(columnDefinition="text")
    private String license;
    @Column
    private Boolean isEncrypted = false;
    private String awsIAMRoleExternalId;
    private String awsIAMRoleARN;
    private String awsAccessKeyId;
    private String awsSecretAccessKey;
    private String awsCMKId;
    private String awsRoute53ManagedZoneId;
    private String gcpCloudDnsManagedZoneId;
    private String azureSubscription;
    private String azureTenantId;
    private String azureEnvironment;
    private String azureKeyVaultId;
    private String azureKeyName;
    private String azureKeyVersion;
    private String gcpProjectId;
    private String gcpLocationId;
    private String gcpKeyRing;
    private String gcpCryptoKey;
    private String gcpCryptoKeyVersion;
    @Column(columnDefinition="text")
    private String gcpServiceAccountKey;

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.id;
        }
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Nonnull
    public CloudAccount getVirtualCloudAccount(FMSettings settings) {
        CloudAccount cloudAccount = new CloudAccount();
        cloudAccount.setId(this.id);
        cloudAccount.setTenant(this);
        cloudAccount.setLabel("Fleet Manager Account");
        cloudAccount.setDescription("This account is the one used by Fleet Manager.");
        cloudAccount.setEncrypted(this.isEncrypted());
        switch (settings.cloud) {
            case AWS: {
                if (StringUtils.isNotBlank((String)this.awsIAMRoleExternalId)) {
                    cloudAccount.setAwsAuthenticationMode(CloudAccount.AWSAuthenticationMode.IAM_ROLE);
                } else if (StringUtils.isNotBlank((String)this.awsSecretAccessKey)) {
                    cloudAccount.setAwsAuthenticationMode(CloudAccount.AWSAuthenticationMode.KEYPAIR);
                } else {
                    cloudAccount.setAwsAuthenticationMode(CloudAccount.AWSAuthenticationMode.DEFAULT_INSTANCE_CREDENTIALS);
                }
                cloudAccount.setAwsIAMRoleExternalId(this.awsIAMRoleExternalId);
                cloudAccount.setAwsIAMRoleARN(this.awsIAMRoleARN);
                cloudAccount.setAwsAccessKeyId(this.awsAccessKeyId);
                cloudAccount.setAwsSecretAccessKey(this.awsSecretAccessKey);
                break;
            }
            case AZURE: {
                cloudAccount.setAzureSubscription(this.azureSubscription);
                cloudAccount.setAzureTenantId(this.azureTenantId);
                if (settings.azureSettings.tenantId != null && settings.azureSettings.tenantId.equals(this.azureTenantId)) {
                    if (StringUtils.isNotBlank((String)settings.azureSettings.secret)) {
                        cloudAccount.setAzureSecret(settings.azureSettings.secret);
                        cloudAccount.setAzureAuthenticationMode(CloudAccount.AzureAuthenticationMode.OAUTH2_AUTHENTICATION_METHOD_CLIENT_SECRET);
                    } else if (StringUtils.isNotBlank((String)settings.azureSettings.certificatePath)) {
                        cloudAccount.setAzureCertificatePath(settings.azureSettings.certificatePath);
                        cloudAccount.setAzureCertificatePassword(settings.azureSettings.certificatePassword);
                        cloudAccount.setAzureAuthenticationMode(CloudAccount.AzureAuthenticationMode.OAUTH2_AUTHENTICATION_METHOD_CERTIFICATE);
                    } else if (StringUtils.isNotBlank((String)settings.azureSettings.managedIdentityId)) {
                        cloudAccount.setAzureManagedIdentityId(settings.azureSettings.managedIdentityId);
                        cloudAccount.setAzureAuthenticationMode(CloudAccount.AzureAuthenticationMode.MANAGED_IDENTITY);
                    } else {
                        cloudAccount.setAzureEnvironment(settings.azureSettings.environment);
                        cloudAccount.setAzureAuthenticationMode(CloudAccount.AzureAuthenticationMode.DEFAULT_INSTANCE_CREDENTIALS);
                    }
                    if (StringUtils.isNotBlank((String)settings.azureSettings.VHDCacheResourceGroup)) {
                        cloudAccount.setAzureImageResourceGroup(settings.azureSettings.VHDCacheResourceGroup);
                    } else {
                        JSONObject instanceMetadata = AzureInstanceMetadataReader.getInstanceMetadata();
                        cloudAccount.setAzureImageResourceGroup(instanceMetadata.getJSONObject("compute").getString("resourceGroupName"));
                    }
                } else {
                    cloudAccount.setAzureEnvironment(this.azureEnvironment);
                    cloudAccount.setAzureAuthenticationMode(CloudAccount.AzureAuthenticationMode.DEFAULT_INSTANCE_CREDENTIALS);
                    JSONObject instanceMetadata = AzureInstanceMetadataReader.getInstanceMetadata();
                    cloudAccount.setAzureImageResourceGroup(instanceMetadata.getJSONObject("compute").getString("resourceGroupName"));
                }
                cloudAccount.setAzureManagedIdentityId(settings.azureSettings.managedIdentityId);
                break;
            }
            case GCP: {
                cloudAccount.setGcpProjectId(this.gcpProjectId);
                cloudAccount.setGcpServiceAccountKey(this.gcpServiceAccountKey);
                if (StringUtils.isNotBlank((String)this.gcpServiceAccountKey)) {
                    cloudAccount.setGcpAuthenticationMode(CloudAccount.GCPAuthenticationMode.JSON_KEY);
                } else {
                    cloudAccount.setGcpAuthenticationMode(CloudAccount.GCPAuthenticationMode.DEFAULT_INSTANCE_CREDENTIALS);
                }
                if (!StringUtils.isEmpty((String)cloudAccount.getGcpProjectId())) break;
                cloudAccount.setGcpProjectId(settings.gcpSettings.projectId);
            }
        }
        return cloudAccount;
    }

    public void setAuthenticationFromVirtualCloudAccount(CloudAccount cloudAccount) {
        this.isEncrypted = cloudAccount.isEncrypted();
        this.awsIAMRoleExternalId = cloudAccount.getAwsIAMRoleExternalId();
        this.awsIAMRoleARN = cloudAccount.getAwsIAMRoleARN();
        this.awsAccessKeyId = cloudAccount.getAwsAccessKeyId();
        this.awsSecretAccessKey = cloudAccount.getAwsSecretAccessKey();
        this.azureSubscription = cloudAccount.getAzureSubscription();
        this.azureTenantId = cloudAccount.getAzureTenantId();
        this.azureEnvironment = cloudAccount.getAzureEnvironment();
        this.gcpProjectId = cloudAccount.getGcpProjectId();
        this.gcpServiceAccountKey = cloudAccount.getGcpServiceAccountKeyOrKeyPath();
    }

    public LicenseMode getLicenseMode() {
        return this.licenseMode;
    }

    public void setLicenseMode(LicenseMode licenseMode) {
        this.licenseMode = licenseMode;
    }

    public String getLicenseToken() {
        return this.licenseToken;
    }

    public void setLicenseToken(String licenseToken) {
        this.licenseToken = licenseToken;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAwsCMKId() {
        return this.awsCMKId;
    }

    public void setAwsCMKId(String awsCMKId) {
        this.awsCMKId = awsCMKId;
    }

    public String getAwsRoute53ManagedZoneId() {
        return this.awsRoute53ManagedZoneId;
    }

    public void setAwsRoute53ManagedZoneId(String awsRoute53ManagedZoneId) {
        this.awsRoute53ManagedZoneId = awsRoute53ManagedZoneId;
    }

    public String getGcpCloudDnsManagedZoneId() {
        return this.gcpCloudDnsManagedZoneId;
    }

    public void setGcpCloudDnsManagedZoneId(String gcpCloudDnsManagedZoneId) {
        this.gcpCloudDnsManagedZoneId = gcpCloudDnsManagedZoneId;
    }

    public String getAzureKeyVaultId() {
        return this.azureKeyVaultId;
    }

    public boolean isAzureKeyVaultSetup() {
        return StringUtils.isNotBlank((String)this.azureKeyVaultId) && StringUtils.isNotBlank((String)this.azureKeyName) && StringUtils.isNotBlank((String)this.azureKeyVersion);
    }

    public void setAzureKeyVaultId(String azureKeyVaultId) {
        this.azureKeyVaultId = azureKeyVaultId;
    }

    public String getAzureKeyName() {
        return this.azureKeyName;
    }

    public void setAzureKeyName(String azureKeyName) {
        this.azureKeyName = azureKeyName;
    }

    public String getAzureKeyVersion() {
        return this.azureKeyVersion;
    }

    public void setAzureKeyVersion(String azureKeyVersion) {
        this.azureKeyVersion = azureKeyVersion;
    }

    public String getGcpLocationId() {
        return this.gcpLocationId;
    }

    public void setGcpLocationId(String gcpLocationId) {
        this.gcpLocationId = gcpLocationId;
    }

    public String getGcpKeyRing() {
        return this.gcpKeyRing;
    }

    public void setGcpKeyRing(String gcpKeyRing) {
        this.gcpKeyRing = gcpKeyRing;
    }

    public String getGcpCryptoKey() {
        return this.gcpCryptoKey;
    }

    public void setGcpCryptoKey(String gcpCryptoKey) {
        this.gcpCryptoKey = gcpCryptoKey;
    }

    public String getGcpCryptoKeyVersion() {
        return this.gcpCryptoKeyVersion;
    }

    public void setGcpCryptoKeyVersion(String gcpCryptoKeyVersion) {
        this.gcpCryptoKeyVersion = gcpCryptoKeyVersion;
    }

    public String getCloudTags() {
        return this.cloudTags;
    }

    public CloudTagList getCloudApplicableTags() {
        return CloudTagList.fromJSON(this.getCloudTags()).with("fm:tenantId", this.getId());
    }

    public void setCloudTags(String cloudTags) {
        this.cloudTags = cloudTags;
    }

    public Boolean isEncrypted() {
        return this.isEncrypted != null && this.isEncrypted != false;
    }

    public void setEncrypted(boolean encrypted) {
        this.isEncrypted = encrypted;
    }

    public String getAzureSubscription() {
        return this.azureSubscription;
    }

    public String getAzureTenantId() {
        return this.azureTenantId;
    }

    public void copyEncryption(Tenant origin) {
        this.awsCMKId = origin.awsCMKId;
        this.azureKeyVaultId = origin.azureKeyVaultId;
        this.azureKeyName = origin.azureKeyName;
        this.azureKeyVersion = origin.azureKeyVersion;
        this.gcpCryptoKey = origin.gcpCryptoKey;
        this.gcpKeyRing = origin.gcpKeyRing;
        this.gcpCryptoKeyVersion = origin.gcpCryptoKeyVersion;
        this.gcpLocationId = origin.gcpLocationId;
    }

    public static enum LicenseMode {
        NONE,
        AUTO_UPDATE,
        STATIC;

    }
}

