/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server;

import com.codahale.metrics.Timer;
import com.dataiku.common.audit.AuditContextBase;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.CallTracingAspectBase;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.security.FMMetaAuthService;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import org.apache.log4j.MDC;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Order(value=1)
public class FMCallTracingAspect
extends CallTracingAspectBase {
    @Autowired
    private FMMetaAuthService authService;
    @Autowired
    private DatabaseAccessService dbService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.tracing");

    @Around(value="traceRequestMapping()")
    public Object doCall(ProceedingJoinPoint joinpoint) throws Throwable {
        MethodSignature signature = (MethodSignature)joinpoint.getSignature();
        Method method = signature.getMethod();
        String mapping = FMCallTracingAspect.getMapping((Method)method);
        this.setAuditContext(mapping);
        DKULogger.startCurrentCall();
        Timer timer = DSSMetrics.registry().timer("dku.api.internal.calltime" + mapping.replace('/', '.').replace('*', '_'));
        Timer.Context timerCtx = timer.time();
        long startTime = System.currentTimeMillis();
        AuthCtx authCtx = null;
        String displayedUserStr = null;
        HttpServletRequest request = null;
        try {
            request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            AuditContextBase.setIPInfo((HttpServletRequest)request);
            authCtx = this.authService.getFromAnyNoXSRF(request);
            if (authCtx != null) {
                AuditContextBase.setAuthContext((AuthCtx)authCtx);
                displayedUserStr = authCtx.getIdentifier();
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to trace call info: ", (Throwable)e);
        }
        if (displayedUserStr != null) {
            MDC.put((String)"user", displayedUserStr);
        }
        MDC.put((String)"apiCall", (Object)mapping);
        CallTracingAspectBase.AllCallsLoggingContext aclc = this.buildAllCallsLoggingContext(joinpoint, signature);
        aclc.logStart(mapping, displayedUserStr, authCtx, request);
        Throwable thrown = null;
        try {
            Object object = joinpoint.proceed();
            return object;
        }
        catch (Throwable t) {
            thrown = t;
            throw t;
        }
        finally {
            long endTime = System.currentTimeMillis();
            long executeTime = endTime - startTime;
            try {
                timerCtx.stop();
            }
            catch (Throwable t) {
                logger.error((Object)"Error caught during API call finalization. Ignoring it.", t);
            }
            try {
                aclc.logDone(mapping, displayedUserStr, authCtx, executeTime, thrown, request);
                aclc.emitAudit(executeTime);
            }
            catch (Throwable t) {
                logger.error((Object)"Error caught during API call finalization. Ignoring it.", t);
            }
            try {
                this.reportPossibleAuthenticationFailure(thrown, null);
            }
            catch (Throwable t) {
                logger.error((Object)"Error caught during API call finalization. Ignoring it.", t);
            }
            try {
                DKULogger.endCurrentCall();
            }
            catch (Throwable t) {
                logger.error((Object)"Error caught during API call finalization. Ignoring it.", t);
            }
            try {
                MDC.clear();
            }
            catch (Throwable t) {
                logger.error((Object)"Error caught during API call finalization. Ignoring it.", t);
            }
            try {
                AuditContextBase.reset();
            }
            catch (Throwable t) {
                logger.error((Object)"Error caught during API call finalization. Ignoring it.", t);
            }
            try {
                this.dbService.close();
            }
            catch (Throwable t) {
                logger.error((Object)"Error caught during API call finalization. Ignoring it.", t);
            }
        }
    }

    @Pointcut(value="@annotation(org.springframework.web.bind.annotation.RequestMapping)")
    public void traceRequestMapping() {
    }
}

