/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.fm.server;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.logging.MainLoggingConfigurator;
import com.dataiku.dip.server.JettyUtils;
import com.dataiku.dip.server.WebPathConfiguration;
import com.dataiku.dip.server.controllers.AuditedCallAspect;
import com.dataiku.dip.util.ServletUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ServletHolder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Connector;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConfiguration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.HttpConnectionFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Server;
import com.dataiku.dss.shadelib.org.eclipse.jetty.server.ServerConnector;
import com.dataiku.fm.cloud.CloudInstanceService;
import com.dataiku.fm.model.settings.FMSettings;
import com.dataiku.fm.server.FMApp;
import com.dataiku.fm.server.FMCallTracingAspect;
import com.dataiku.fm.server.FMSpring;
import com.dataiku.fm.server.db.DatabaseAccessService;
import com.dataiku.fm.server.snapshots.SnapshotsManagementTask;
import com.dataiku.fm.utils.TaskSchedulerService;
import jakarta.servlet.Servlet;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class FMServerMain {
    private static final DKULogger logger;

    public static void main(String[] args) {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        FMApp.autoconfigure();
        MainLoggingConfigurator.configure((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.FM);
        DKUApp.setProcessType((MainLoggingConfigurator.ProcessType)MainLoggingConfigurator.ProcessType.APIMAIN);
        long init = System.currentTimeMillis();
        try {
            Logger.getLogger((String)"com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppClassLoader").setLevel(Level.INFO);
            if (System.getenv("DKU_FMMAIN_PORT") == null) {
                throw new IllegalArgumentException("Missing DKU_FMMAIN_PORT environment variable");
            }
            if (System.getenv("DKUINSTALLDIR") == null) {
                throw new IllegalArgumentException("Missing DKUINSTALLDIR environment variable");
            }
            MainLoggingConfigurator.configureLimits();
            FMServerMain.printHelloBanner();
            AnnotationConfigWebApplicationContext appContext = new AnnotationConfigWebApplicationContext();
            FMSpring.registerServerServices(appContext);
            appContext.register(new Class[]{ControllersProxySupport.class});
            appContext.refresh();
            long servicesReady = System.currentTimeMillis();
            logger.infoV("Services ready after %d ms", new Object[]{servicesReady - init});
            FMSettings settings = FMApp.getFMSettingsUnsafe();
            DKUApp.setSecurityFlags((boolean)settings.security.hideErrorStacks, (boolean)settings.security.secureCookies, (boolean)false);
            DSSMetrics.registerJVMMetrics();
            DSSMetrics.startJMXReporter();
            int backendPort = Integer.parseInt(System.getenv("DKU_FMMAIN_PORT"));
            logger.infoV("Starting on port %d", new Object[]{backendPort});
            Server server = new Server(backendPort);
            server.setOpenEarly(false);
            TaskSchedulerService taskSchedulerService = new TaskSchedulerService();
            HttpConfiguration httpConfig = JettyUtils.createHttpConfiguration();
            HttpConnectionFactory http = new HttpConnectionFactory(httpConfig);
            ServerConnector connector = new ServerConnector(server, new ConnectionFactory[]{http});
            connector.setIdleTimeout(-1L);
            connector.setPort(backendPort);
            server.setConnectors(new Connector[]{connector});
            ServletContextHandler sch = ServletUtils.createServletContext((int)100000000, (String)"/");
            logger.info((Object)"Creating the dispatcher servlet");
            sch.addServlet(new ServletHolder((Servlet)new DispatcherServlet((WebApplicationContext)appContext)), "/*");
            appContext.register(new Class[]{WebPathConfiguration.class});
            JettyUtils.addHandlers((Server)server, (ServletContextHandler)sch);
            logger.info((Object)"Loaded the servlet");
            server.start();
            long serverStarted = System.currentTimeMillis();
            logger.infoV("Server started after %d ms (%s ms to complete initialization)", new Object[]{serverStarted - servicesReady, serverStarted - init});
            boolean debugScheduler = Boolean.parseBoolean(DKUApp.getProperty((String)"schedule.every.minute", (String)"false"));
            taskSchedulerService.addScheduledTask(new SnapshotsManagementTask((DatabaseAccessService)appContext.getBean(DatabaseAccessService.class), (CloudInstanceService)appContext.getBean(CloudInstanceService.class), settings.deleteExpiredAutomaticSnapshots), debugScheduler ? TaskSchedulerService.TaskSchedulerPeriod.MINUTE : TaskSchedulerService.TaskSchedulerPeriod.HOUR);
            server.join();
        }
        catch (Exception e) {
            logger.error((Object)"Server start failed", (Throwable)e);
            System.exit(1);
        }
    }

    private static void printHelloBanner() {
        logger.info((Object)"----------------------------------------");
        logger.info((Object)"Fleet Manager startup");
        logger.infoV("FM home: %s", new Object[]{System.getenv("DIP_HOME")});
        logger.infoV("OS: %s %s %s - Java: %s %s", new Object[]{System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.vendor"), System.getProperty("java.version")});
    }

    static {
        System.setProperty("DIP_HOME", System.getenv("DIP_HOME"));
        logger = DKULogger.getLogger((String)"dku");
    }

    @Configuration
    @EnableAspectJAutoProxy
    public static class ControllersProxySupport {
        @Bean
        public FMCallTracingAspect tracer() {
            logger.info((Object)"Hello, mon chou ! La cavalerie est arrivee !");
            return new FMCallTracingAspect();
        }

        @Bean
        public AuditedCallAspect auditer() {
            return new AuditedCallAspect();
        }
    }
}

